<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSslCommerzSoftwoerImplementionStatusAndCommentToOrderTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->enum('software_integration_status', ['pending', 'processing', 'completed', 'failed'])->default('pending');
            $table->text('software_integration_comment')->nullable();
            $table->decimal('software_integration_try')->default(0);
            $table->longText('post_data')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn('software_integration_status');
            $table->dropColumn('software_integration_comment');
            $table->dropColumn('software_integration_try');
            $table->dropColumn('post_data');
        });
    }
}
