<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayBillLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pay_bill_logs', function (Blueprint $table) {
            $table->id();
            $table->string('trxn_id')->nullable();
            $table->foreignId('client_id')->nullable();
            $table->longText('request')->nullable();
            $table->longText('response')->nullable();
            $table->enum('status',['Success','Failed'])->nullable();
            $table->string('payment_method')->nullable();
            $table->string('request_url')->nullable();
            $table->text('error_message')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pay_bill_logs');
    }
}
