<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClusterMap extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cluster_map', function (Blueprint $table) {
            $table->id();
            $table->foreignId("parent_id")->nullable();
            $table->enum("parent_type", ["cluster", "cable"])->nullable();
            $table->string("type")->default("cluster");
            $table->foreignId("parent_cluster")->nullable();
            $table->string("name");
            $table->json("coordinates");
            $table->string("box")->nullable();
            $table->longText("remarks")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cluster_map');
    }
}
