<?php

namespace App\Services;

use Carbon\Carbon;
use App\Models\Client;
use App\Models\BillGenerate;
use App\Models\Billpayment;
use App\Models\CustomerAccount;
use Illuminate\Support\Facades\DB;



class TopmenuService
{


  static function getDashboardCounter(){
    $data = array();

    

    $accounts = BillGenerate::all();
    $billpayment = Billpayment::all();

    $clientsaccount = DB::table('clients')
                ->leftJoin('customer_accounts','clients.id','=','customer_accounts.client_id')
                // ->leftJoin('clientsinfo','clients.id','=','clientsinfo.client_id')
                ->select('clients.id as id','pop_id','package_id','userid','expire_date','created_by','client_approval','clients.created_at as cdate',
                'clients.updated_at as udate','clients_status','totalPaid','dueAmount','totalDiscount','totalBillAmount')
                ->get();
    // dd($clientsaccount);

    $thisMonth = Carbon::now()->firstOfMonth();
     
              
    // all customer
    // $data['allCustomer']  =  $clientsaccount->count();

    

    // monthly new customer

    $data['monthlyCustomer'] = $clientsaccount->where('cdate','>=', $thisMonth)->count();

    //total customer bill amount

    $data['totalCustomerBillAmount'] = $accounts->sum('bill_amount');

    //this month total bill amount

    $data['thisMonthTotalBillAmount'] = $accounts->where('created_at.month',date('m'))
                                                    ->where('created_at.year',date('Y'))
                                                    ->sum('bill_amount');

    //total bill payment
    $client_accounts = CustomerAccount::get();
    $total_advance_balance = 0;
    foreach($client_accounts as $client_account){
      if($client_account->dueAmount < 0){
        $total_advance_balance  += $client_account->dueAmount;
      }
    }
    $total_due = BillGenerate::sum('bill_amount') - Billpayment::sum('paid_amount') - Billpayment::sum('discount_amount') + $total_advance_balance;
    // dd($total_due);
    $data['total_due'] = $total_due;

    $data['totalCustomerBillPayment'] =  $billpayment->sum('paid_amount');

    //this month customer payment amount
 
    $data['thisMonthBillPaymentAmount'] = $billpayment->where('created_at.month',date('m'))
                                                       ->where('created_at.year',date('Y'))
                                                       ->sum('paid_amount');

    
    $data['thisMonthDiscountAmount'] = $billpayment->where('created_at.month',date('m'))
                                                      ->where('created_at.year',date('Y'))
                                                      ->sum('discount_amount');

                                                      
    $first_day_of_this_month = Carbon::parse(date('Y-m-01'))->format('Y-m-d 00:00:00');
    $total_previous_bill_generate = BillGenerate::where('created_at','<',$first_day_of_this_month)->get();
    $total_previous_bill_payment = Billpayment::where('created_at','<',$first_day_of_this_month)->get();

    $total_previous_due = $total_previous_bill_generate->sum('bill_amount') - $total_previous_bill_payment->sum('paid_amount') - $total_previous_bill_payment->sum('discount_amount');

    $data['total_previous_due'] = $total_previous_due;
    //expired customer amount 
    // dd($data['thisMonthTotalBillAmount'],$data['thisMonthBillPaymentAmount'],$data['thisMonthDiscountAmount']);

    $data['thisMonthBillDueAmount'] = $data['thisMonthTotalBillAmount'] - ($data['thisMonthBillPaymentAmount'] + $data['thisMonthDiscountAmount']);




    $data['allPaymentDueCustomerCount'] = $clientsaccount->where('clients_status','!=','deactive')->where('dueAmount','>',0)->count();

    //payment done customer count

    $data['allPaymentDoneCustomerCount'] = $clientsaccount->where('clients_status','!=','deactive')->where('dueAmount','<',1)->count();


    //expired customer count

    $data['expiredCustomer'] = $clientsaccount->where('clients_status','expired')->count();

    // total deactivated customer count

    // $data['totalDeactivatedCustomer'] = $clientsaccount->where('clients_status','deactive')->count();


    // monthly deactivated customer list

    $data['monthlyDeactivatedCustomer'] = $clientsaccount->where('udate','>=', $thisMonth)->where('clients_status','deactive')->count();


    //total current amount

    return $data;

  }

  static function countPendingCustomer()
  {
    $list = Client::conditionlist();

    return $list->count();
  }

  static function countExpiredCustomer()
  {
    $list = Client::expireClientList();
   
    return $list;
                  
  }
  static function countMonthlyCustomer()
  {
    $list = Client::monthlyClientList();
    //dd($list);
    return $list;
                  
  }

  static function countDeactivatedCustomer()
  {
    return Client::where('clients_status','deactive')
                  ->count();
  }

  static function countNewCustomer()
  {
    return Client::whereMonth('clients.created_at','=' , date('m'))
                  ->whereYear('clients.created_at','=' , date('Y'))
                  ->count();
  }

  // all customer
  static function countAllcustomer()
  {
        $list = Client::allCustomerlist();

        return $list;
  }

// active customer
  static function activeCustomer(){

    $list = Client::activeCustomerlist();
    return $list;
}


  static function deactivatedCustomer(){
        $list = Client::deactiveCustomerlist();
        return $list;
  }

  static function monthlyCustomerReport(){
    $data = [];
    $list = Client::whereMonth('clients.created_at','=' , date('m'))
                    ->whereYear('clients.created_at','=' , date('Y'));

    $data['activeCustomer'] = $list->where('clients_status','!=','expired')->count();
    $data['expiredCustomer'] = $list->where('clients_status','!=','expired')->count();

    dd($data);
    
    
  }

  static function monthlyAccountReport(){ 
    $start = Carbon::now()->startOfMonth();
    $end = Carbon::now()->addMonth()->startOfMonth();
    $data = array();

    $data['totalMonthlyBillAmount'] = BillGenerate::whereRaw("created_at BETWEEN '$start' AND '$end'")->sum('bill_amount');
    $data['totalMonthlyPaymentAmount'] = Billpayment::whereRaw("created_at BETWEEN '$start' AND '$end'")->sum('paid_amount');
    return $data;
  }
  static function totalClosedCustomer()
  {
        $list = Client::closedClientList();

        return $list;
  }


}