<?php

namespace App\Services;

use Carbon\Carbon;
use Exception;

class ExpireDateRoundService{

    public function roundDate($expireDate)
    {
        $old_expire_date = Carbon::parse($expireDate)->format('Y-m-d 00:00:00');
        $new_expire_date = Carbon::parse($old_expire_date)->addMonth();

        $difference_of_month = Carbon::parse($new_expire_date)->format('m') - Carbon::parse($old_expire_date)->format('m');
        // dd($difference_of_month);
        if($difference_of_month >=2){
            $expireDate = Carbon::parse($new_expire_date)->subMonth()->lastOfMonth()->format('Y-m-d 00:00:00');
            return $expireDate;
        }

        return Carbon::parse($new_expire_date)->format('Y-m-d 00:00:00');
    }

    public function roundExpireDateForRecharge($old_expire_date, $new_expire_date){
        $difference_of_month = Carbon::parse($new_expire_date)->format('m') - Carbon::parse($old_expire_date)->format('m');

        if($difference_of_month >=2){
            $expireDate = Carbon::parse($new_expire_date)->subMonth()->lastOfMonth()->format('Y-m-d 00:00:00');
            return $expireDate;
        }

        return Carbon::parse($new_expire_date)->format('Y-m-d 00:00:00');
    }

    public function currentMonthExpireDate($billingCycle)
    {
        try {
            $expireDate = Carbon::parse(date($billingCycle . '-M-Y'));

        } catch (Exception $e) {

            $expireDate = now()->endOfMonth();
        }

       
        return $expireDate->format('Y-m-d 00:00:00');
    }
}
