<?php

namespace App\Services;

use App\Classes\MikrotikService\SyncWithMk;
use App\Http\Controllers\Clients\IdDisconnectController;
use App\Http\Controllers\Clients\IdEnableDisableController;
use App\Models\Client;
use App\Models\User_log;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class ClientActiveService
{
    public function active($id,$details,$authUserId): void
    {
        DB::transaction(function () use ($id,$details,$authUserId) {
        $client = Client::with('pop', 'pop.nas', 'packages', 'customerAccount')->find($id);

            if (Carbon::parse($client->expire_date)->addDay($client->payment_dadeline) < today()) {

                $dif = Carbon::parse($client->expire_date)->diffInMonths(today());

                if ($dif > 0 && $client->pop->bill_generate == 'yes') {


                    $new_exp = Carbon::parse(date($client->billing_cycle . '-m-Y'));
                    $newExpireDayWithCurrentDay = date('Y-m-d 00:00:00');

                    if ($client->billing_cycle > date('d')) {

                        if (getBillingType() != 'day_to_day') {
                            // (new IdEnableDisableController())->reactiveBillGenerate($client, $new_exp);
                            (new GenerateMonthlyBill)->generate($client);
                        }

                        $client->expire_date = Carbon::parse($newExpireDayWithCurrentDay)->subDay(1);
                        $client->billing_cycle = date('d');
                        $client->clients_status = $client->pop->experity_check == 'Yes' ? 'expired' : 'disable';
                        $client->save();
                        (new GenerateMonthlyBill)->generate($client);
                        (new IdEnableDisableController())->enableInRadius($client);
                    } else {

                        $new_exp = Carbon::parse($new_exp)->addMonth();
                        $newExpireDayWithCurrentDay = date('Y-m-d 00:00:00');


                        // dd($expire_date);
                        if (getBillingType() != 'day_to_day') {
                            // (new IdEnableDisableController())->reactiveBillGenerate($client, $new_exp);
                        }

                        $client->expire_date = Carbon::parse($newExpireDayWithCurrentDay)->subDay(1);
                        $client->billing_cycle = date('d') - 1;
                        $client->clients_status =  $client->pop->experity_check == 'Yes' ? 'expired' : 'disable';
                        $client->save();

                    (new GenerateMonthlyBill)->generate($client);

                    }
                } else {
                    (new IdEnableDisableController())->enableInRadius($client, false);

                    (new IdEnableDisableController())->generatePreviousMonthBill($client);
                    (new GenerateMonthlyBill)->generate($client);


                    $client->clients_status = 'expired';
                    $client->save();
                }
            } else {
                $client->clients_status = 'active';
                $client->save();
                (new IdEnableDisableController())->enableInRadius($client);
            }

            if ($client->pop->experity_check == 'Yes') {
                (new IdEnableDisableController())->enableInRadius($client);
            }

            User_log::create([
                'log_type' => 'id_enable',
                'user_id' => $authUserId,
                'details' => $details,
                'client_id' => $client->id
            ]);

            if (checkAPI()){

                $mikrotik = new SyncWithMk();
                try {
                    $mikrotik->syncSingleClient($client->id);
                } catch (Exception $e) {
                    Log::error('Mikrotik Sync Error: ' . $e->getMessage());
                }
            }

        }, 1);
    }

}
