<?php

namespace App\Models\map;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Tube extends Model
{
    use HasFactory;
    protected $table = "tube_map";

    protected $fillable = [
        "cable_id",
        "tube_number",
        "fiber_count",
    ];

    public function cable()
    {
        return $this->belongsTo(Cable::class, "cable_id");
    }

    public function fibers()
    {
        return $this->hasMany(Fiber::class);
    }
}
