<?php

namespace App\Models\map;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SplitterOut extends Model
{
    use HasFactory;
    protected $table = "splitter_out_map";
    protected $fillable = [
        "splitter_id",
        "out_number",
        "connected_component_type",
        "connected_component_id",
        "fiber_id",
        "cable_id",
        "type"
    ];

    public function splitter()
    {
        return $this->belongsTo(Splitter::class, "splitter_id");
    }

    // this is useless for now
    public function device()
    {
        return $this->belongsTo(Device::class, "device_id");
    }

    public function fiber()
    {
        return $this->belongsTo(Fiber::class, "fiber_id");
    }

    function connectedComponent()
    {
        return $this->morphTo(null, "connected_component_type", "connected_component_id");
    }
}
