<?php

namespace App\Models\map;

use App\Models\Client;
use App\Models\Clientsinfo;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Splitter extends Model
{
    use HasFactory;
    protected $table = "splitter_map";
    protected $fillable = [
        "name",
        "cluster_id",
        "cable_id",
        "fiber_id",
        "parent_id",
        "splitter_id",
        "split_ratio",
        "used",
        "remarks",
        "connected_component_type",
        "connected_component_id",
        "type"
    ];

    protected $morphClass = 'splitter';


    public function connectedComponent()
    {
        return $this->morphTo(null, "connected_component_type", "connected_component_id");
    }

    public function fiber()
    {
        return $this->belongsTo(Fiber::class, "fiber_id");
    }

    public function splitterOut()
    {
        return $this->hasMany(SplitterOut::class, "splitter_id");
    }

    public function port()
    {
        return $this->belongsTo(Port::class, "port_id");
    }

    public function scopePort()
    {
        return $this->belongsTo(Cable::class, "cable_id");
    }

    // this is only for handling error in relation
    public function device()
    {
        return $this->belongsTo(Device::class, "device_id");
    }
    public function client()
    {
        return $this->belongsTo(Client::class, "client_id");
    }

    public function splitter()
    {
        return $this->belongsTo(Splitter::class, "splitter_id");
    }
}
