<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BandSale extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id',
        'invoice_no',
        'billing_date',
        'subTotal',
        'marketing_total',
        'total',
        'repeat_invoice',
        'bank_account_id'
    ];

    public function sateItems(){
        return $this->hasMany(BandSaleItem::class,'sale_id');
    }

    public function bandwidthSaleCustomer(){
        return $this->belongsTo(BwCustomer::class,'customer_id');
    }

    public function bankAccount(){
        return $this->belongsTo(Banking::class, 'bank_account_id');
    }
}
