<?php

namespace App\Jobs;

use App\Http\Controllers\PackageChangeController;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SubPackageEditJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    private $clients;
    private $package_id;
    public function __construct($clients, $package_id)
    {
        $this->clients = $clients;
        $this->package_id = $package_id;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        foreach ($this->clients as $client) {
            if($client->pop->subreseller == 'yes'){
                try{
                    (new PackageChangeController)->package_change_user($client, $this->package_id);
                }catch(\Exception $e){

                }
            }
        }
    }
}
