<?php

namespace App\Jobs;

use App\Classes\OtherReseller\MonthlyBillGenerateClass;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ResellerClientMonthlyBillGenerateJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    private $clients;
    private $bill_month;
    public function __construct($clients, $bill_month)
    {
        $this->clients = $clients;
        $this->bill_month = $bill_month;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        foreach ($this->clients as $user) {

            (new MonthlyBillGenerateClass)->generate($user, $this->bill_month);
        }
    }
}
