<?php

namespace App\Jobs;

use App\Classes\BillgenerateUpdate;
use App\Models\Client;
use Illuminate\Bus\Queueable;
use App\Services\GenerateMonthlyBill;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;

class BillGenerateJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    private $lists;
    private $bill_month;

    public function __construct($lists,$bill_month)
    {
        $this->bill_month = $bill_month;
        $this->lists = $lists;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {        

        foreach ($this->lists as $user) {
            echo $user->id . '<br>';
            (new GenerateMonthlyBill)->generate($user,$this->bill_month);
        }
    }
}
