<?php

namespace App\Imports;

use App\Models\Client;
use App\Models\Clientsinfo;
use App\Models\Packages;
use App\Models\Pop;
use App\Models\SubPackage;
use Carbon\Carbon;
use Exception;
use Maatwebsite\Excel\Concerns\Importable;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\ToCollection;

class clientImportCustomize implements ToCollection
{
    use Importable;

    public function collection(Collection $rows)
    {
        // customize client import without heading

        $count = 0;
        foreach ($rows as $row) {
            $count++;
            $list_billing_cycle = preg_replace("/[^0-9]/", "", $row[7]);
            $int_billing_cycle = $list_billing_cycle;
            $expire = date('2024-09-' . $int_billing_cycle . ' 00:00:00');
            $today = Carbon::parse(today())->format('Y-m-d 00:00:00');

            if (strtotime($expire) < strtotime($today)) {
                $expire = Carbon::parse($expire)->addMonth();
            }

            if (is_numeric($row[15])) {
                $carbonDate = Carbon::parse(($row[15] - 25569) * 86400)->format('Y-m-d 00:00:00');
                $day = Carbon::parse($carbonDate)->format('d');
            } else {
                $carbonDate = Carbon::parse($row[15])->format('Y-m-d 00:00:00');
                $day = Carbon::parse($carbonDate)->format('d');
            }

            // if (is_numeric($row[3])) {
            //     $check_client->expire_date = Carbon::parse(($row[3] - 25569) * 86400)->format('Y-m-d 00:00:00');
            // } else {
            //     $date = Carbon::createFromFormat('d/m/y', $row[3]); // Explicit format
            //     $check_client->expire_date = $date->format('Y-m-d 00:00:00');
            // }

            $pop = Pop::where('popname', $row[6])->first();
            if ($pop == null) {
                dd("pop", $row[6], $row[7], $count);
            }

            $package = Packages::where('package_name', $row[4])->first();
            $sub_package = SubPackage::where('name', trim($row[4]))->first();
            if ($pop->subreseller == 'no') {
                if ($package == null) {
                    dd("package", $row[4]);
                }
            }

            if ($pop->subreseller == 'yes') {
                if ($sub_package == null) {
                    dd("sub-package", trim($row[4]));
                }
            }

            $check_client = Client::where('userid', trim($row[0]))->first();
            if ($check_client == null) {
                $client = new Client();
                if (is_numeric($row[0]) && strlen($row[0]) == 10 && strlen($row[0]) < 11) {
                    $client->userid = '0' . trim($row[0]);
                } else {
                    $client->userid = trim($row[0]);
                }

                $client->customer_code = trim($row[16]);
                $client->customer_type = trim($row[19]);

                if (is_numeric($row[1]) && strlen($row[1]) == 10 && strlen($row[1]) < 11) {
                    $client->password = '0' . trim($row[1]);
                } else {
                    $client->password = trim($row[1]);
                }

                if ($pop->subreseller == 'no') {
                    $client->package_id = $package->id;
                }
                if ($pop->subreseller == 'yes') {
                    $client->package_id = $sub_package->package_id;
                    $client->sub_package_id = $sub_package->id;
                }
                $client->pop_id = $pop->id;
                $client->billing_cycle = $day; // $int_billing_cycle;
                // $client->expire_date = $expire;
                // $client->expire_date = Carbon::parse($expire)->format('Y-m-d 00:00:00');
                if (is_numeric($row[15])) {
                    $client->expire_date = Carbon::parse(($row[15] - 25569) * 86400)->format('Y-m-d 00:00:00');
                } else {
                    $client->expire_date = Carbon::parse($row[15])->format('Y-m-d 00:00:00');
                }
                $client->required_cable = 0;
                $client->created_by = auth()->user()->id;
                $client->client_approval = "pending";
                $client->clients_status = "deactive";
                $client->save();
                $client->customer_id = $client->id;
                $client->save();
                $clientInfo = new Clientsinfo();
                $clientInfo->client_id = $client->id;
                $clientInfo->clients_name = $row[2];
                if (strlen($row[3]) < 11) {
                    $clientInfo->contact_no = '0' . $row[3];
                }
                if (strlen($row[3]) == 11) {
                    $clientInfo->contact_no = $row[3];
                }
                $clientInfo->email = $row[8] ?? "";
                $clientInfo->father_name = $row[9];
                $clientInfo->mother_name = $row[10];
                $clientInfo->area = $row[11];
                $clientInfo->remarks = $row[12] ?? "";
                if (is_numeric($row[13])) {
                    $clientInfo->joinDate = Carbon::parse(($row[13] - 25569) * 86400)->format('Y-m-d 00:00:00');
                } else {
                    if (isset($row[13])) {
                        $clientInfo->joinDate = Carbon::parse($row[13])->format('Y-m-d 00:00:00');
                    } else {
                        $clientInfo->joinDate = Carbon::parse(today())->format('Y-m-d 00:00:00');
                    }
                }
                $clientInfo->cable_type = $row[14] == "Fiber" ? "fiber_optic_4_core" : "cat5";
                $clientInfo->road_no = $row[16];
                $clientInfo->building_no = $row[13];
                $clientInfo->flat_no = $row[14];
                $clientInfo->national_id = $row[18];
                $clientInfo->save();
            }
        }
    }
}
