<?php

namespace App\Imports;

use App\Models\Client;
use App\Models\Clientsinfo;
use Exception;
use Maatwebsite\Excel\Concerns\Importable;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\ToCollection;

class ClientUpdate implements ToCollection
{
    use Importable;

    public function collection(Collection $rows)
    {
        // userid wise info update

        $count = 0;
        foreach ($rows as $row) {
            $count++;
            $check_client = Client::where('userid', trim($row[0]))->first();
            if ($check_client != null) {
                $clientInfo = Clientsinfo::where('client_id', $check_client->id)->first();
                if (strlen($row[1]) < 11) {
                    $clientInfo->contact_no = '0' . $row[1];
                }
                if (strlen($row[1]) == 11) {
                    $clientInfo->contact_no = $row[1];
                }
                $clientInfo->save();
            }
        }
    }
}
