<?php

namespace App\Http\Controllers;

use App\Models\VoiceGateway;
use App\Classes\EditLogHistory;
use Illuminate\Http\Request;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Artisan;

class VoiceGatewayController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:voice_sms_gateway_index', ['only' => ['index']]);
    }

    public function index()
    {
        $data = [
            'gateway' => VoiceGateway::paginate(500)
        ];
        return view('voice_gateway.index', $data);
    }

    public function create()
    {
        return view('voice_gateway.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:voice_gateways',
            'api_url' => 'required',
        ]);

        $gateway = new VoiceGateway();
        $gateway->fill($request->all());

        if ((VoiceGateway::where('status', '=', 'enable')->exists()) && ($gateway->status == 'enable')) {
            Toastr::error('Already One item is Enable', '', ['progressbar' => true]);
            return redirect()->route('voice-gateway.create');
        } else {
            $gateway->save();
            Toastr::success('Voice Gateway Added Successfully', '', ['progressbar' => true]);
            return redirect()->route('voice-gateway.index');
        }
    }

    public function edit($id)
    {
        $gateway = VoiceGateway::find($id);
        return view('voice_gateway.edit', [
            'gateway' => $gateway
        ]);
    }

    public function update(Request $request, $id)
    {
        $type = 'Voice Gateway';
        $old_info = VoiceGateway::where('id', $id)->first();

        $gateway = VoiceGateway::find($id);
        $previous_voice_gateway = VoiceGateway::where('status', '=', 'enable')->first();

        if ($previous_voice_gateway != null) {
            if ($id != $previous_voice_gateway->id) {
                Toastr::error('Already One item is Enable', '', ['progressbar' => true]);
                return redirect()->back();
            }
        }

        $request->validate([
            'name' => 'required|unique:voice_gateways,name,' . $gateway->id,
            'api_url' => 'required',
        ]);

        $gateway->fill($request->all());
        $gateway->update();

        $new_info = VoiceGateway::find($gateway->id);
        (new EditLogHistory)->editLogSave($gateway, $type, $old_info, $new_info);

        Toastr::success('Voice Gateway Updated Successfully', '', ['progressbar' => true]);
        return redirect()->route('voice-gateway.index');
    }

    public function destroy($id)
    {
        $gateway = VoiceGateway::find($id);

        if ($gateway->status == 'enable') {
            Toastr::error('Cannot delete enabled gateway', '', ['progressbar' => true]);
            return redirect()->back();
        }

        $gateway->delete();
        Toastr::success('Voice Gateway Deleted Successfully', '', ['progressbar' => true]);

        return redirect()->route('voice-gateway.index');
    }
}

