<?php

namespace App\Http\Controllers;

use App\Exports\ExportTokenReport;
use App\Models\Employee;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class SupportTicketSummaryController extends Controller
{
    public function secondToReadAbleTime($total_seconds){
        $days = floor($total_seconds / (60 * 60 * 24));
            $remaining_seconds = $total_seconds % (60 * 60 * 24);

            $hours = floor($remaining_seconds / (60 * 60));
            $remaining_seconds %= (60 * 60);

            $minutes = floor($remaining_seconds / 60);
            $seconds = $remaining_seconds % 60;

            $time = "";

            if($days > 0)
                $time .= $days . "d ";
            if($hours > 0)
                $time .= $hours . "h ";
            if($minutes > 0)
                $time .= $minutes . "m ";
            if($seconds > 0)
                $time .= $seconds . "s ";


            // return "Days: $days, Hours: $hours, Minutes: $minutes, Seconds: $seconds";
            return $time;
    }

    public function tokenReportSummary(){
        $employees = Employee::with('assignedTickets')->whereHas('assignedTickets')->get();
        $todayEnd = date('Y-m-d 23:59:59');
        $startOfLastSevenDays = date('Y-m-d 00:00:00', strtotime('-7 days'));
        $employeeDataLat7Days = [];
        $employeeDataLat30Days = [];
        foreach($employees as $employee){
            $total_time_close = 0;
            $total_time_close_last_7_days = 0;
            $total_token_last_7_days = 0;
            $total_token_last_30_days = 0;

            $lowestCloseTimeLast7Days = null;
            $highestCloseTimeLast7Days = null;

            $lowestCloseTimeLast30Days = null;
            $highestCloseTimeLast30Days = null;

            $tokenIdLowestCloseTimeLast7Days = null;
            $tokenIdHighestCloseTimeLast7Days = null;

            $tokenIdLowestCloseTimeLast30Days = null;
            $tokenIdHighestCloseTimeLast30Days = null;


            $last_7_days_tickets = $employee->assignedTickets()->whereBetween('created_at', [$startOfLastSevenDays,$todayEnd])->get();

            foreach($employee->assignedTickets as $token){
                $thisTokenCloseTimeInSecond =  strtotime($token->close_time) - strtotime($token->assign_time);

                if($lowestCloseTimeLast30Days == null){
                    $lowestCloseTimeLast30Days = $thisTokenCloseTimeInSecond;
                    $tokenIdLowestCloseTimeLast30Days = $token->id;
                }

                if($highestCloseTimeLast30Days == null){
                    $highestCloseTimeLast30Days = $thisTokenCloseTimeInSecond;
                    $tokenIdHighestCloseTimeLast30Days = $token->id;
                }

                if($lowestCloseTimeLast30Days > $thisTokenCloseTimeInSecond){
                    $lowestCloseTimeLast30Days = $thisTokenCloseTimeInSecond;
                    $tokenIdLowestCloseTimeLast30Days = $token->id;
                }

                if($highestCloseTimeLast30Days < $thisTokenCloseTimeInSecond){
                    $highestCloseTimeLast30Days = $thisTokenCloseTimeInSecond;
                    $tokenIdHighestCloseTimeLast30Days = $token->id;
                }

                $total_time_close += $thisTokenCloseTimeInSecond;
                $total_token_last_30_days += 1;
            }

            foreach($last_7_days_tickets as $token){
                $thisTokenCloseTimeInSecond =  strtotime($token->close_time) - strtotime($token->assign_time);

                if(!$lowestCloseTimeLast7Days){
                    $lowestCloseTimeLast7Days = $thisTokenCloseTimeInSecond;
                    $tokenIdLowestCloseTimeLast7Days = $token->id;
                }

                if(!$highestCloseTimeLast7Days){
                    $highestCloseTimeLast7Days = $thisTokenCloseTimeInSecond;
                    $tokenIdHighestCloseTimeLast7Days = $token->id;
                }

                if($lowestCloseTimeLast7Days > $thisTokenCloseTimeInSecond){
                    $lowestCloseTimeLast7Days = $thisTokenCloseTimeInSecond;
                    $tokenIdLowestCloseTimeLast7Days = $token->id;
                }

                if($highestCloseTimeLast7Days < $thisTokenCloseTimeInSecond){
                    $highestCloseTimeLast7Days = $thisTokenCloseTimeInSecond;
                    $tokenIdHighestCloseTimeLast7Days = $token->id;
                }

                $total_time_close_last_7_days += $thisTokenCloseTimeInSecond;
                $total_token_last_7_days += 1;
            }

            if($total_token_last_7_days != 0){
                $averageCloseTime7days = $total_time_close_last_7_days / $total_token_last_7_days;
            }

            if($total_token_last_30_days != 0){
                $averageCloseTime30days = $total_time_close / $total_token_last_30_days;
            }

            if($total_token_last_7_days == 0){
                $averageCloseTime7days = $total_time_close_last_7_days ;
            }

            if($total_token_last_30_days == 0){
                $averageCloseTime30days = $total_time_close ;
            }




            $thisEmployeeDataLast30Days = [
                'name' => $employee->name,
                'total_token_last_30_days' => $total_token_last_30_days,
                'averageCloseTime30days' => $this->secondToReadAbleTime($averageCloseTime30days),
                'tokenIdLowestCloseTimeLast30Days' => $tokenIdLowestCloseTimeLast30Days,
                'tokenIdHighestCloseTimeLast30Days' => $tokenIdHighestCloseTimeLast30Days,
                'lowestCloseTimeLast30Days' => $this->secondToReadAbleTime($lowestCloseTimeLast30Days),
                'highestCloseTimeLast30Days' => $this->secondToReadAbleTime($highestCloseTimeLast30Days),
                'highestCloseTimeLast30DaysOnlyTime' => $highestCloseTimeLast30Days,
            ];

            $thisEmployeeDataLast7Days = [
                'name' => $employee->name,
                'total_token_last_7_days' => $total_token_last_7_days,
                'averageCloseTime7days' => $this->secondToReadAbleTime($averageCloseTime7days),
                'tokenIdLowestCloseTimeLast7Days' => $tokenIdLowestCloseTimeLast7Days,
                'tokenIdHighestCloseTimeLast7Days' => $tokenIdHighestCloseTimeLast7Days,
                'lowestCloseTimeLast7Days' => $this->secondToReadAbleTime($lowestCloseTimeLast7Days),
                'highestCloseTimeLast7Days' => $this->secondToReadAbleTime($highestCloseTimeLast7Days),
                'highestCloseTimeLast7DaysOnlyTIme' => $highestCloseTimeLast7Days,

            ];

            if($total_token_last_7_days != 0){

                array_push($employeeDataLat7Days,$thisEmployeeDataLast7Days);
            }
            array_push($employeeDataLat30Days,$thisEmployeeDataLast30Days);

        }

        // dd($employeeData);

        $data = [
            'employeeDataLat7Days' => collect($employeeDataLat7Days)->sortBy('highestCloseTimeLast7DaysOnlyTIme')->reverse()->toArray(),
            'employeeDataLat30Days' => collect($employeeDataLat30Days)->sortBy('highestCloseTimeLast30DaysOnlyTime')->reverse()->toArray(),
        ];

        // dd($data);

        return view('token.summary.report',$data);

    }

    public function tokenReportDownload(Request $request)
    {
        $employees = Employee::with('assignedTickets')->whereHas('assignedTickets')->get();
        $todayEnd = date('Y-m-d 23:59:59');
        $startOfLastSevenDays = date('Y-m-d 00:00:00', strtotime('-7 days'));
        $employeeDataLat7Days = [];
        $employeeDataLat30Days = [];
        foreach($employees as $employee){
            $total_time_close = 0;
            $total_time_close_last_7_days = 0;
            $total_token_last_7_days = 0;
            $total_token_last_30_days = 0;
            $lowestCloseTimeLast7Days = null;
            $highestCloseTimeLast7Days = null;
            $lowestCloseTimeLast30Days = null;
            $highestCloseTimeLast30Days = null;
            $tokenIdLowestCloseTimeLast7Days = null;
            $tokenIdHighestCloseTimeLast7Days = null;
            $tokenIdLowestCloseTimeLast30Days = null;
            $tokenIdHighestCloseTimeLast30Days = null;
            $last_7_days_tickets = $employee->assignedTickets()->whereBetween('created_at', [$startOfLastSevenDays,$todayEnd])->get();

            foreach($employee->assignedTickets as $token){
                $thisTokenCloseTimeInSecond =  strtotime($token->close_time) - strtotime($token->assign_time);
                if($lowestCloseTimeLast30Days == null){
                    $lowestCloseTimeLast30Days = $thisTokenCloseTimeInSecond;
                    $tokenIdLowestCloseTimeLast30Days = $token->id;
                }
                if($highestCloseTimeLast30Days == null){
                    $highestCloseTimeLast30Days = $thisTokenCloseTimeInSecond;
                    $tokenIdHighestCloseTimeLast30Days = $token->id;
                }
                if($lowestCloseTimeLast30Days > $thisTokenCloseTimeInSecond){
                    $lowestCloseTimeLast30Days = $thisTokenCloseTimeInSecond;
                    $tokenIdLowestCloseTimeLast30Days = $token->id;
                }
                if($highestCloseTimeLast30Days < $thisTokenCloseTimeInSecond){
                    $highestCloseTimeLast30Days = $thisTokenCloseTimeInSecond;
                    $tokenIdHighestCloseTimeLast30Days = $token->id;
                }
                $total_time_close += $thisTokenCloseTimeInSecond;
                $total_token_last_30_days += 1;
            }

            foreach($last_7_days_tickets as $token){
                $thisTokenCloseTimeInSecond =  strtotime($token->close_time) - strtotime($token->assign_time);
                if(!$lowestCloseTimeLast7Days){
                    $lowestCloseTimeLast7Days = $thisTokenCloseTimeInSecond;
                    $tokenIdLowestCloseTimeLast7Days = $token->id;
                }
                if(!$highestCloseTimeLast7Days){
                    $highestCloseTimeLast7Days = $thisTokenCloseTimeInSecond;
                    $tokenIdHighestCloseTimeLast7Days = $token->id;
                }
                if($lowestCloseTimeLast7Days > $thisTokenCloseTimeInSecond){
                    $lowestCloseTimeLast7Days = $thisTokenCloseTimeInSecond;
                    $tokenIdLowestCloseTimeLast7Days = $token->id;
                }
                if($highestCloseTimeLast7Days < $thisTokenCloseTimeInSecond){
                    $highestCloseTimeLast7Days = $thisTokenCloseTimeInSecond;
                    $tokenIdHighestCloseTimeLast7Days = $token->id;
                }
                $total_time_close_last_7_days += $thisTokenCloseTimeInSecond;
                $total_token_last_7_days += 1;
            }
            if($total_token_last_7_days != 0){
                $averageCloseTime7days = $total_time_close_last_7_days / $total_token_last_7_days;
            }
            if($total_token_last_30_days != 0){
                $averageCloseTime30days = $total_time_close / $total_token_last_30_days;
            }
            if($total_token_last_7_days == 0){
                $averageCloseTime7days = $total_time_close_last_7_days ;
            }
            if($total_token_last_30_days == 0){
                $averageCloseTime30days = $total_time_close ;
            }

            $thisEmployeeDataLast30Days = [
                'name' => $employee->name,
                'total_token_last_30_days' => $total_token_last_30_days,
                'averageCloseTime30days' => $this->secondToReadAbleTime($averageCloseTime30days),
                'tokenIdLowestCloseTimeLast30Days' => $tokenIdLowestCloseTimeLast30Days,
                'tokenIdHighestCloseTimeLast30Days' => $tokenIdHighestCloseTimeLast30Days,
                'lowestCloseTimeLast30Days' => $this->secondToReadAbleTime($lowestCloseTimeLast30Days),
                'highestCloseTimeLast30Days' => $this->secondToReadAbleTime($highestCloseTimeLast30Days),
                'highestCloseTimeLast30DaysOnlyTime' => $highestCloseTimeLast30Days,
            ];

            $thisEmployeeDataLast7Days = [
                'name' => $employee->name,
                'total_token_last_7_days' => $total_token_last_7_days,
                'averageCloseTime7days' => $this->secondToReadAbleTime($averageCloseTime7days),
                'tokenIdLowestCloseTimeLast7Days' => $tokenIdLowestCloseTimeLast7Days,
                'tokenIdHighestCloseTimeLast7Days' => $tokenIdHighestCloseTimeLast7Days,
                'lowestCloseTimeLast7Days' => $this->secondToReadAbleTime($lowestCloseTimeLast7Days),
                'highestCloseTimeLast7Days' => $this->secondToReadAbleTime($highestCloseTimeLast7Days),
                'highestCloseTimeLast7DaysOnlyTIme' => $highestCloseTimeLast7Days,
            ];

            if($total_token_last_7_days != 0){
                array_push($employeeDataLat7Days,$thisEmployeeDataLast7Days);
            }
            array_push($employeeDataLat30Days,$thisEmployeeDataLast30Days);
        }

        $data = [
            'employeeDataLat7Days' => collect($employeeDataLat7Days)->sortBy('highestCloseTimeLast7DaysOnlyTIme')->reverse()->toArray(),
            'employeeDataLat30Days' => collect($employeeDataLat30Days)->sortBy('highestCloseTimeLast30DaysOnlyTime')->reverse()->toArray(),
        ];

        $new_data[] = '';
        if($request->type == "week"){

            $new_data = $data['employeeDataLat7Days'];
            return Excel::download(new ExportTokenReport($new_data, 7), 'tokens.csv');

        }elseif($request->type == "month"){

            $new_data = $data['employeeDataLat30Days'];
            return Excel::download(new ExportTokenReport($new_data, 30), 'tokens.csv');
        }
    }
}
