<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

class QrCodeController extends Controller
{
    /**
     * Show a simple form to generate a QR code for arbitrary text.
     */
    public function generator(Request $request)
    {
        $qrCode = null;
        $text = '';

        if ($request->has('text')) {
            $validated = $request->validate([
                'text' => 'required|string|max:500',
            ]);

            $text = trim($validated['text']);
            $qrCode = QrCode::format('svg')->size(240)->generate($text);

            // Prepare SVG data URI for download (avoids imagick requirement)
            $qrCodeSvg = QrCode::format('svg')->size(600)->margin(2)->generate($text);
            $qrCodeDownload = 'data:image/svg+xml;base64,' . base64_encode($qrCodeSvg);
        }

        return view('qr.generator', [
            'text' => $text,
            'qrCode' => $qrCode,
            'qrCodeDownload' => $qrCodeDownload ?? null,
        ]);
    }
}

