<?php

namespace App\Http\Controllers;

use App\Jobs\ClientDeleteJob;
use App\Jobs\MakeClientActiveJob;
use App\Jobs\MakeClientCloseJob;
use App\Jobs\MakeClientDeactiveJob;
use App\Jobs\MakeClientDisableJob;
use App\Models\Billpayment;
use App\Models\Client;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;

class MultipleCustomerStatusChangeController extends Controller
{
    public function multipleCustomerStatusChange(Request $request)
    {
        if (empty($request->ids) || count($request->ids) <= 0) {
            Toastr::error("Please Select Customer");
            return redirect()->back();
        }

        if (!$request->status) {
            Toastr::error("Please Select status");
            return redirect()->back();
        }
        // dd($request->all());

        if ($request->status == "disable") {
            $count = 0;
            foreach ($request->ids as $id) {
                $client = Client::with('pop', 'pop.nas', 'clientsinfo')->find($id);
                $details = "Client disable";

                if ($client->clients_status != 'disable') {
                    MakeClientDisableJob::dispatch($client, $details, auth()->user()->id);
                    $count++;
                }
            }
            // this is an ajax request
            if ($count > 0) {
                return response()->json(['success' => $count . ' Client disable request is in processing queue']);
            } else {
                return response()->json(['success' => 'Clients already disabled'], 200); // Return 200 status code
            }
        } elseif ($request->status == "enable") {
            $count = 0;
            foreach ($request->ids as $id) {
                $client = Client::with('packages')->find($id);

                if (checkSettings('disable_limit_over_user') == 'enable') {

                    $totalUpload = $client->down_bandwidth ?? 0;
                    $totalDownload = $client->up_bandwidth ?? 0;
                    $packageLimit = $client->packages->limite_quantity ?? 0;

                    $extraLimit = $client->bandwidth_limit ?? 0;

                    $totalLimit = $packageLimit + $extraLimit;

                    $totalUsed = $totalUpload + $totalDownload;

                    // dd($totalUsed, $totalLimit);

                    if ($totalUsed > $totalLimit) {
                        if (!auth()->user()->can('enable-limit-over-user')) {
                            // skip this client
                            continue;
                        }
                    }
                }

                $details = "Client enable";

                if ($client->clients_status != 'active') {

                    if ($client->clients_status == 'deactive') {
                        if (auth()->user()->can('customer-reactivate')) {
                            MakeClientActiveJob::dispatch($client->id, $details, auth()->user()->id);
                            $count++;
                        }
                    }else{

                        MakeClientActiveJob::dispatch($client->id, $details, auth()->user()->id);
                        $count++;
                    }

                }
            }
            // this is an ajax request
            if ($count > 0) {
                return response()->json(['success' => $count . ' Client enable request is in processing queue']);
            } else {
                return response()->json(['success' => 'Clients already enable or active'], 200); // Return 200 status code
            }
        } elseif ($request->status == "deactive") {
            $count = 0;
            foreach ($request->ids as $id) {
                $client = Client::with('pop', 'pop.nas', 'clientsinfo')->find($id);
                $details = "Client deactive";

                if ($client->clients_status != 'deactive') {
                    MakeClientDeactiveJob::dispatch($client, $details, auth()->user()->id);
                    $count++;
                }
            }
            if ($count > 0) {
                return response()->json(['success' => $count . ' Client deactive request is in processing queue']);
            } else {
                return response()->json(['success' => 'Clients already deactivated'], 200);
            }
        } elseif ($request->status == "close") {
            $count = 0;
            foreach ($request->ids as $id) {
                $client = Client::with('pop', 'pop.nas', 'clientsinfo')->find($id);
                $details = "Client close";

                if ($client->deleted_at == null) {
                    // dd('processing');
                    MakeClientCloseJob::dispatch($client, $details, auth()->user()->id);
                    $count++;
                }
            }
            if ($count > 0) {
                return response()->json(['success' => $count . ' Client close request is in processing queue']);
            } else {
                return response()->json(['success' => 'Clients already closed'], 200);
            }
        } elseif ($request->status == "delete") {
            $count = 0;
            foreach ($request->ids as $id) {
                $client = Client::find($id);
                $payment = Billpayment::where('client_id', $client->id)->first();
                if (empty($payment)) {
                    ClientDeleteJob::dispatch($client, auth()->user()->id);
                    $count++;
                }
            }

            if ($count > 0) {
                return response()->json(['success' => $count . ' Client delete request is in processing queue']);
            } else {
                return response()->json(['success' => 'All Client has payment history you can close those client'], 200); // Return 200 status code
            }
        }
    }
}
