<?php

namespace App\Http\Controllers;

use App\Models\Employee;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class EmployeeController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:employee_index|employee_create|employee_edit|employee_destroy', ['only' => ['index', 'show']]);
        $this->middleware('permission:employee_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:employee_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:employee_destroy', ['only' => ['destroy']]);

    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {


        $employees = Employee::with('admin')->paginate(1000);


        return view('employee.index',[
            'employees' => $employees,
            'page_title' => 'Employee List',
            'add_button' => 'true',
            'url' => route('employees.create'),
            'class' => 'text-white bg-blue-600',
            'value' => 'Add New Employees'
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('employee.create',[
            'page_title' => 'Add New Employee'
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request->all());

        $this->validate($request,[
            'name' => 'required',
            'user_id' => 'required',
            'mobile_office' => 'required',
        ],
    );

        Employee::create($request->all());
        clearCache('employees');

        return redirect()->route('employees.index')->with('success_message','Employee Added Successful!');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $employee = Employee::find($id);

        $users =  User::where('email', '!=', 'rokibulhasan.356@gmail.com')
            ->where('email', '!=', 'admin@billingfix.xyz')
            ->where('email', '!=', 'support@yetfix.com');

        $ulist= $users->pluck('id')->toArray();
        $employeeUsers = Employee::whereIn('admin_user_id', $ulist)->pluck('admin_user_id')->toArray();
        $checkedUser = $users->whereNotIn('id', $employeeUsers);

        $change = User::where('email', '!=', 'rokibulhasan.356@gmail.com')
            ->where('email', '!=', 'admin@billingfix.xyz')
            ->where('email', '!=', 'support@yetfix.com')->get();

        return view('employee.update',[
            'employee' => $employee,
            'page_title' => 'Update Employee Information',
            'allUser' => $checkedUser->get(),
            'changeUser' => $change
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $employee = Employee::find($id);

        $this->validate($request,[
                'name' => 'required',
                'mobile_office' => 'required',
            ]
        );

        // dd($request->all());



        $employee->update($request->all());
        clearCache('employees');

        $request->session()->flash('success_message', 'Employee Update Successfully Done');
        return redirect()->route('employees.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $employee = Employee::find($id);
        $employee->delete();
        session()->flash('success_message', 'Employee Delete Successfully Done');
        return redirect()->route('employees.index');
    }
}
