<?php

namespace App\Http\Controllers;

use App\Models\Client;
use Illuminate\Http\Request;

class ClientTransferController extends Controller
{
    public function transferClientInfo(Request $request)
    {
        $clients = Client::withTrashed()
            ->with('clientsinfo')
            ->when($request->has('client_id'), function ($query) use ($request) {
                $query->where('id', '>', $request->client_id);
            })
            ->get();

        $data = $clients->map(function ($client) {
            return [
                'client_id'    => $client->id,
                'name'         => $client->userid . ' (' . ($client->clientsinfo->clients_name ?? '') . ')',
                'address'      => $client->clientsinfo->area ?? '',
                'client_phone' => $client->clientsinfo->contact_no ?? '',
            ];
        });

        return response()->json($data);
    }


    public function syncClientInfo(Request $request)
    {
        $clients = Client::withTrashed()
            ->with('clientsinfo')
            ->when($request->has('client_id'), function ($query) use ($request) {
                $query->where('id', $request->client_id);
            })
            ->get();

        $data = $clients->map(function ($client) {
            return [
                'client_id'    => $client->id,
                'name'         => $client->userid . ' (' . ($client->clientsinfo->clients_name ?? '') . ')',
                'address'      => $client->clientsinfo->area ?? '',
                'client_phone' => $client->clientsinfo->contact_no ?? '',
            ];
        });

        return response()->json($data);
    }
}
