<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Reseller\ResellerRechargeController;
use App\Models\ResellerRechargeReport;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CheckResellerSSLRecharge extends Controller
{
    public function processPendingPayment()
    {
        $ssl_info = config('sslcommerz');
        $ssl_store_id = $ssl_info["apiCredentials"]["store_id"];
        $ssl_store_password = $ssl_info["apiCredentials"]["store_password"];
        $base_url = "https://securepay.sslcommerz.com/validator/api/validationserverAPI.php?store_id=" . $ssl_store_id . "&store_passwd=" . $ssl_store_password . "&&val_id=";

        if (checkSettings('ssl-reseller-recharge') == 'enable') {

            $start = Carbon::parse(today()->subDay(1))->format('Y-m-d 00:00:00');
            $end = Carbon::parse(today())->format('Y-m-d 23:59:59');

            $orders  = DB::table('orders')->whereBetween('created_at', [$start, $end])
                ->where('software_integration_status', 'pending')
                ->where('val_id', '!=', null)
                ->get();

            foreach ($orders as $order) {
                if ($order->address == 'ResellerRecharge') {
                    $checkPayment = ResellerRechargeReport::where('payment_gateway_transaction_id', $order->transaction_id)->first();
                    if ($checkPayment != null) {
                        DB::table('orders')
                            ->where('id', $order->id)
                            ->update(['software_integration_status' => 'completed', 'software_integration_comment' => "completed with out any schedule"]);
                    } else {
                        try {
                            if ($order->val_id != null) {

                                $url = $base_url . $order->val_id;
                                $curl = curl_init();

                                curl_setopt_array($curl, array(
                                    CURLOPT_URL => $url,
                                    CURLOPT_RETURNTRANSFER => true,
                                    CURLOPT_ENCODING => '',
                                    CURLOPT_MAXREDIRS => 10,
                                    CURLOPT_TIMEOUT => 0,
                                    CURLOPT_FOLLOWLOCATION => true,
                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                    CURLOPT_CUSTOMREQUEST => 'GET',
                                    CURLOPT_HTTPHEADER => array(
                                        'Cookie: f5avraaaaaaaaaaaaaaaa_session_=EMBGMHAKLNOKBPJNJBBMJAFOELOEGOBECMGKNKJNBDDCFLDILNPFHMPHLIHIEIGHEGODGLEBNNJMGKEBODGADBGIFGOFJIKJANOOHILILOKAJNHPMHEDEELPMCHBLNMG; TS01d00da5=016ef4e8326a95917eb982cebff0fa61e7cccb819bce96555de07b8d16d156ce3ba34d2a7f39a319dad73abe6c6319624343c81f78e5f9ef2c9a5f361136711250e2af2797'
                                    ),
                                ));

                                $response = curl_exec($curl);

                                // dd($response);

                                curl_close($curl);
                                $result = json_decode($response);
                                // dd($result);
                                if ($result->status == "VALIDATED") {
                                    DB::beginTransaction();
                                    try {
                                        // $this->sslpayment($order->customer_id, $order->amount, $order->transaction_id);

                                        $status = (new ResellerRechargeController)->recharge(
                                            $order->customer_id,
                                            $order->amount,
                                            $order->transaction_id,
                                            $order->val_id,
                                            'SSL-Commerz',
                                            'Payment from Online useing SSL-Commerz. Payment Process By: ' .  $order->email,
                                        );

                                        DB::commit();

                                        DB::table('orders')
                                            ->where('id', $order->id)
                                            ->update([
                                                'software_integration_status' => 'completed',
                                                'software_integration_comment' => "completed with schedule" . $order->software_integration_try++ . " try",
                                                'software_integration_try' => $order->software_integration_try + 1,
                                            ]);
                                    } catch (\Exception $e) {
                                        DB::rollBack();
                                    }
                                }
                            }
                        } catch (\Exception $e) {
                            DB::table('orders')
                                ->where('id', $order->id)
                                ->update([
                                    'software_integration_status' => 'pending',
                                    'software_integration_comment' => $e->getMessage(),
                                    'software_integration_try' => $order->software_integration_try + 1,
                                ]);
                        }
                    }
                }
            }
        }
    }
}
