<?php

namespace App\Exports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class BankTransfarExport implements FromCollection, WithHeadings, ShouldAutoSize
{
    /**
     * @var \Illuminate\Support\Collection
     */
    protected $data;

    public function __construct(Collection $data)
    {
        $this->data = $data;
    }

    public function headings(): array
    {
        return [
            'Date',
            'Account Name',
            'Account No',
            'Check No',
            'Bank Name',
            'Branch Name',
            'Description',
            'Deposit/Withdraw By',
            'Deposit Amount (TK)',
            'Withdraw Amount (TK)',
        ];
    }

    public function collection()
    {
        return $this->data->map(function ($transfar) {
            return [
                optional($transfar->created_at)->format('d-m-Y'),
                optional($transfar->bank)->account_name,
                optional($transfar->bank)->account_no,
                $transfar->check_no,
                optional($transfar->bank)->bank_name,
                optional($transfar->bank)->branch_name,
                $transfar->description,
                $transfar->by,
                $transfar->diposit_amount,
                $transfar->withdraw_amount,
            ];
        });
    }
}


