<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class TrimUserName extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'trim:username';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $clientsWithSpaces = DB::table('clients')
            ->where('pop_id', 4)
            ->where(function ($query) {
                $query->where('userid', 'LIKE', ' %')
                    ->orWhere('userid', 'LIKE', '% ');
            })
            ->get();

        foreach ($clientsWithSpaces as $client) {

            DB::table('clients')
                ->where('id', $client->id)
                ->update([
                    'userid' => trim($client->userid)
                ]);
        }
        echo "Affected rows: " . count($clientsWithSpaces) . "\n";
    }
}
