<?php

namespace App\Console\Commands;

use App\Models\Client;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class OflineDisconnect extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ofline:disconnect';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Ofline Disconnect';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // Log::info("log -ofline:disconnect");


        if (checkSettings('ofline-disconnect') == 'enable') {
            $online = DB::table('radacct')
                ->select('username')
                ->whereNull('acctstoptime')
                ->pluck('username')
                ->toArray();

            $list = Client::with('pop', 'packages', 'pop.nas')
                ->where('clients_status', '!=', 'deactive')
                ->whereNotIn('userid', $online)->get();



            foreach ($list as $client) {
                $result = exec('echo User-Name=' . $client->userid . ' | radclient ' . $client->pop->nas->nasname . ':3799 "disconnect" ' . $client->pop->nas->secret);
            }
        }else{
            
        }
    }
}
