<?php

namespace App\Console\Commands;

use App\Jobs\ResellerClientBillPaymentSyncJob;
use App\Models\User;
use Illuminate\Console\Command;
use App\Models\Reseller;
use App\Models\Pop;
use App\Models\Client;

class AllResellerClientAccountSync extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'reseller:sync-all-client-accounts';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync all reseller client accounts balance';

    /**
     * Execute the console command.
     */
    public function handle()
    {

        $otherResellerIds = Reseller::where('reseller_type', 'other')->pluck('id');
        $popsIds = Pop::whereIn('reseller_id', $otherResellerIds)->pluck('id');

       $allOtherResellerClient = Client::whereIn('pop_id', $popsIds)->pluck('id');

       foreach ($allOtherResellerClient as $client) {
            ResellerClientBillPaymentSyncJob::dispatch($client);
       }


    }
}
