<?php
namespace App\Classes\SMS;

use App\Jobs\SendSmsJob;
use App\Models\Item;



class StockReminderSms{

    public function sendSms($item_id,$current_quantity){
        $items = Item::with('stockIn','stockOut','itemReturn','itemAdjustment')->find($item_id);

        $text_sms = '';
        $text_sms = $items->name . ' Stock Quantiy = ' . $current_quantity . ', Please check your stock.';

        $numbers = siteinfo()->stock_reminder_contact_numbers;

        if($numbers != null)
        {

            $numbers_arry = explode(',', $numbers);

            foreach($numbers_arry as $number)
            {
                $data = [
                    'message' => $text_sms,
                    'contact_no' => $number,
                    'type' => 'stock_reminder'
                ];

                SendSmsJob::dispatch($data);
            }
        }




    }
}
