<?php

namespace App\Classes\Accounting;

use App\Services\ClientDisconnectService;
use Illuminate\Support\Facades\Log;

class UserDisconnect
{
    protected $username;
    protected $nasIp;
    protected $nasSecret;

    public function __construct($username, $nasIp, $nasSecret)
    {
        $this->username = $username;
        $this->nasIp = $nasIp;
        $this->nasSecret = $nasSecret;
    }

    public function disconnect()
    {
        $command = 'echo "User-Name=' . $this->username . '" | radclient ' . $this->nasIp . ':3799 "disconnect" ' . $this->nasSecret;

        $output = [];
        $returnVar = 0;
       

        if(globalPermission('disconnect-with-api')){
          
            (new ClientDisconnectService())->disconnectExecute($this->username,$this->nasIp,$this->nasSecret,true);
        }else{
            exec($command, $output, $returnVar);
        }

        if ($returnVar !== 0) {
            Log::error('User disconnect failed for: ' . $this->username . ' with NAS: ' . $this->nasIp);
        }

        Log::error('User disconnected successfully: ' . $this->username . ' from NAS: ' . $this->nasIp);
    }
}
