<!DOCTYPE HTML>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title></title>
    <style type="text/css">
        table {
            page-break-inside: auto
        }

        tr {
            page-break-inside: avoid;
            page-break-after: auto
        }

        thead {
            display: table-header-group
        }

        tfoot {
            display: table-footer-group
        }
    </style>
</head>

<body onload="window.print()" onfocus="window.close()">

    <style>
        @media print {

            thead th {
                font-size: 15px !important;
                border: 1px solid #ddd;
            }

            #pop,
            button {
                visibility: hidden;
            }

            table {
                /* width: ; */
            }

            table,
            tr,
            thead th,
            td {
                font-size: 9px !important;
                padding: 2px !important;
                border: 1px solid #010a02;
                border-collapse: collapse;
            }

        }

        .container {
            width: 940px;
            margin: 0 auto;
            padding: 10px;
        }

        .table {

            border-collapse: collapse;
            width: 100%;
            border: 1px solid #4CAF50;
        }

        h2 {
            text-align: center;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        th,
        td {
            border: 1px solid #bbb;
            padding: 10px;
            text-align: left;
        }

        tr:hover {
            background-color: #e5e5e5
        }
    </style>
    <div class="flex flex-col mt-5">
        <div class=" bg-white p-6 rounded-lg">

            <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
                <div class="py-2 align-middle inline-block min-w-full sm:px-6 lg:px-8">
                    <div class="shadow overflow-hidden border-b border-gray-200 sm:rounded-lg" id="PrintSection">
                        <div class="flex justify-between noprint">

                            <button type="button" onclick="window.print()">Print
                                <i class="fa fa-print"></i>
                            </button>
                        </div>

                        <table id="dataTable" class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th scope="col"
                                        class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        ID
                                    </th>
                                    <th scope="col"
                                        class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Paid Amount
                                    </th>
                                    <th scope="col"
                                        class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Client ID
                                    </th>
                                    <th scope="col"
                                        class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Created Date
                                    </th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach ($sales as $r)
                                <tr>
                                    <td class="whitespace-nowrap">
                                        {{ $r->id}}
                                    </td>
                                    <td class="whitespace-nowrap">
                                        {{$r->paid_amount}}
                                    </td>
                                    <td class="whitespace-nowrap text-sm text-gray-500">
                                        {{$r->client_id}}
                                    </td>
                                    <td class="whitespace-nowrap text-sm text-gray-500">
                                        {{$r->created_at}}
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .pop {
            display: none;
        }

        @media print {

            table tr th,
            table,
            tr,
            td {
                font-size: 10px !important;
                padding: 2px !important;
            }
        }
    </style>
    <script type="text/javascript">
        window.onload = function() 
        { window.print(); }
        window.onfocus=function()
        { window.close(); }
    </script>
</body>

</html>