@extends('layout.app')


@section('content')
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Horizontal Form -->
                    <div class="card card-primary">
                        <div class="card-header bg-light">

                            <h3 class="card-title" style="color:#115548;"> Expense Head</h3>
                            <div class="card-tools">
                                <a href="{{ route('expense-head.index') }}"><button class="btn btn-sm btn-primary"><i
                                            class="fa fa-list" aria-hidden="true"></i> &nbsp;See List</button></a>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <!-- form start -->
                        <form method="POST" action="{{ route('expense-head.store') }}" enctype="multipart/form-data">
                            @csrf

                            <div class="card-body">
                                <div class="form-group col-md-4">
                                    <label for="shortname">
                                        Name*
                                    </label>
                                    <input type="text" name="name" class="form-control" placeholder="Enter Name" required>
                                </div>
                                <div class="form-group  float-right">
                                    <button type="submit" name="btn" class=" btn btn-primary">Save</button>
                                </div>
                            </div>
                        </form>

                    </div>
                    <!-- /.card -->
                </div>
                <div class="col-2"></div>
            </div>
            <!-- /.row -->
            <div class="card-body">
                <table id="dataTable" class="table table-bordered">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Expense Head</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($expenseHeads as $row)
                            <tr>
                                <td>{{ $row->id }}</td>
                                <td>{{ $row->name }}</td>
                                <td>
                                    @can('expense-section')


                                        @if (!in_array($row->id, [1, 2, 3, 4, 5, 6]))
                                            @if ($row->name != "BandWith Buy")

                                                <div class="btn-group">
                                                    <a href="{{ route('expense-head.edit', $row->id) }}"
                                                        class="btn btn-sm btn-primary">
                                                        <i class="fa fa-pencil-square-o"></i>
                                                        Edit
                                                    </a>
                                                </div>
                                            @endif

                                            @can('expense-type-history')
                                                <div class="btn-group">
                                                    <a href="{{ route('editLog-history', ['id' => $row->id, 'type' => 'Expense Head']) }}"
                                                        class="btn btn-sm btn-info"><i class="fa-solid fa-timeline"></i>History
                                                    </a>
                                                </div>
                                            @endcan
                                            @can('expense-type-delete')
                                                {{-- <div class="btn-group">
                                                    <form action="{{ route('expense-head.destroy', $row) }}"
                                                        method="POST">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button id="{{ $row->id }}"
                                                            class="btn btn-sm btn-danger">Delete</button>
                                                    </form>
                                                </div> --}}
                                            @endcan
                                        @endif
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
@endsection
@push('script-bottom')
@endpush
