@extends('layout.app')
@section('content')
    <div class="card">
        <div class="card-body">
            <button class="btn btn-success mb-2" onclick="mergeCells()"
            style="background: #a21caf;color:#FFFFFF; margin-top: -4px;">Download
            csv</button>
            <div class="table-responsive">
                <table class="table" id="result_table">
                    <thead class="bg-gray-50 thead-dark">
                        <tr>
                            <th>Sl. No.</th>
                            <th>Manager Name</th>
                            <th>POP Name</th>
                            <th>Active User</th>
                            <th>Expire User</th>
                            <th>Disable User</th>
                            <th>Deactive User</th>
                            <th>Total Without Close</th>
                            <th>Close User</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $totalActive = 0;
                            $totalExpire = 0;
                            $totalDisable = 0;
                            $totalDeactive = 0;
                            $totalWithoutClose = 0;
                            $totalClose = 0;
                            $grandTotal = 0;
                            $counter = 1;
                        @endphp

                        @foreach ($resellers as $reseller)
                            @php
                                $firstRow = true; // To ensure manager name appears only once per reseller
                            @endphp
                            @foreach ($pops->where('reseller_id', $reseller->id) as $pop)
                                @php
                                    $active = $clientCount->where('clients_status', 'active')->where('pop_id', $pop->id)->first()->total ?? 0;
                                    $expired = $clientCount->where('clients_status', 'expired')->where('pop_id', $pop->id)->first()->total ?? 0;
                                    $disabled = $clientCount->where('clients_status', 'disable')->where('pop_id', $pop->id)->first()->total ?? 0;
                                    $deactivated = $clientCount->where('clients_status', 'deactive')->where('pop_id', $pop->id)->first()->total ?? 0;
                                    $closed = $closeClientCount->where('pop_id', $pop->id)->first()->total ?? 0;

                                    $withoutClose = $active + $expired + $disabled + $deactivated;
                                    $total = $withoutClose + $closed;

                                    // Add to global totals
                                    $totalActive += $active;
                                    $totalExpire += $expired;
                                    $totalDisable += $disabled;
                                    $totalDeactive += $deactivated;
                                    $totalWithoutClose += $withoutClose;
                                    $totalClose += $closed;
                                    $grandTotal += $total;
                                @endphp

                                <tr>
                                    @if ($firstRow)
                                        <td rowspan="{{ $pops->where('reseller_id', $reseller->id)->count() }}">{{ $counter++ }}</td>
                                        <td rowspan="{{ $pops->where('reseller_id', $reseller->id)->count() }}">{{ $reseller->name }}</td>
                                        @php $firstRow = false; @endphp
                                    @endif
                                    <td>{{ $pop->popname }}{{ ($pop->subreseller == "yes") ? '(Sub POP)' : '' }}</td>
                                    <td>{{ $active }}</td>
                                    <td>{{ $expired }}</td>
                                    <td>{{ $disabled }}</td>
                                    <td>{{ $deactivated }}</td>
                                    <td>{{ $withoutClose }}</td>
                                    <td>{{ $closed }}</td>
                                    <td>{{ $total }}</td>
                                </tr>
                            @endforeach
                        @endforeach

                        <!-- Final Total Row -->
                        <tr>
                            <td><strong>Total</strong></td>
                            <td></td>
                            <td></td>
                            <td><strong>{{ $totalActive }}</strong></td>
                            <td><strong>{{ $totalExpire }}</strong></td>
                            <td><strong>{{ $totalDisable }}</strong></td>
                            <td><strong>{{ $totalDeactive }}</strong></td>
                            <td><strong>{{ $totalWithoutClose }}</strong></td>
                            <td><strong>{{ $totalClose }}</strong></td>
                            <td><strong>{{ $grandTotal }}</strong></td>
                        </tr>
                    </tbody>
                </table>

            </div>
        </div>

    </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
    <script>
function mergeCells() {
    let table = document.getElementById("result_table");
    let rows = table.getElementsByTagName("tr");
    let lastValue = "";
    let rowspanCount = 1;

    for (let i = 1; i < rows.length - 1; i++) { // Excluding the last total row
        let cell = rows[i].cells[1]; // 2nd column (Manager Name)

        if (cell && cell.innerText === lastValue && cell.innerText != 0) {
            rows[i].deleteCell(1); // Remove duplicate manager name cell
            rows[i - rowspanCount].cells[1].rowSpan = ++rowspanCount; // Increase rowspan of the first occurrence
        } else {
            lastValue = cell ? cell.innerText : "";
            rowspanCount = 1;
        }
    }

    downloadTableAsExcel();
}

function downloadTableAsExcel() {
    let table = document.getElementById("result_table");
    let wb = XLSX.utils.table_to_book(table, { sheet: "Sheet1" });
    XLSX.writeFile(wb, "Customer_ summary.xlsx");
}
    </script>

@endsection
