<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('taginput/bootstrap-tagsinput.css')); ?>" crossorigin="anonymous"
        referrerpolicy="no-referrer">
    <style type="text/css">
        .bootstrap-tagsinput {
            width: 100%;
        }

        .label-info {
            background-color: rgb(36, 219, 204);
        }

        .label {
            /* display: inline-block; */
            padding: .25em .4em;
            font-size: 75%;
            font-weight: 700;
            line-height: 1;
            text-align: center;
            white-space: nowrap;
            vertical-align: baseline;
            border-radius: .25rem;
            transition: color .15s ease-in-out, background-color .15s ease-in-out,
                border-color .15s ease-in-out, box-shadow .15s ease-in-out;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <form action="<?php echo e(route('clients.update', $r->client_id ?? $r->id)); ?>" method="POST" class="form"
        enctype="multipart/form-data">
        <?php echo method_field('PUT'); ?>
        <?php echo csrf_field(); ?>

        <div class="card">
            <div class="card-body">
                <?php if(checkSettings('pictureUpload') == 'enable'): ?>
                    <?php if($r->pop->bill_generate == 'yes' || checkSettings('file_up_for_own_other') == 'enable'): ?>
                        <div class="row" id="file_info">
                            <div class="form-group col-sm-2">
                                <div class="text-center mb-1 image-info"></div>
                                <?php if(checkSettings('store_image_to_s3') == 'enable'): ?>
                                    <?php
                                        $s3Url = Storage::disk('s3')->url(
                                            'customer_profile_picture/' . $r->clientsinfo->customer_profile_picture,
                                        );
                                    ?>

                                    <img width="auto" height="100" src="<?php echo e($s3Url); ?>" alt="No Image">
                                <?php else: ?>
                                    <img width="auto" height="100"
                                        src="<?php echo e(asset('storage/customer_profile_picture/' . $r->clientsinfo->customer_profile_picture)); ?>"
                                        alt="No Image">
                                <?php endif; ?>
                                <label for="customer_profile_picture" class="block pt-2">
                                    Profile Picture
                                    <?php echo e(checkRequired('customer_profile_picture', '*')); ?>

                                </label>
                                <input type="file" name="customer_profile_picture" accept="image/*"
                                    class="form-control-file"
                                    <?php if($r->clientsinfo->customer_profile_picture == null): ?> <?php echo e(checkRequired('customer_profile_picture', 'required')); ?> <?php endif; ?>>
                            </div>
                            <div class="form-group col-sm-2">
                                <div class="text-center mb-1 image-info"></div>
                                <?php if(checkSettings('store_image_to_s3') == 'enable'): ?>
                                    <?php
                                        $s3Url = Storage::disk('s3')->url(
                                            'customer_agrement/' . $r->clientsinfo->customer_agrement,
                                        );
                                    ?>

                                    <img width="auto" height="100" src="<?php echo e($s3Url); ?>" alt="No Image">
                                <?php else: ?>
                                    <img width="auto" height="100"
                                        src="<?php echo e(asset('storage/customer_agrement/' . $r->clientsinfo->customer_agrement)); ?>"
                                        alt="No Image">
                                <?php endif; ?>

                                <label for="customer_agrement" class="block pt-2">
                                    Customer Agrement<?php echo e(checkRequired('customer_agrement_required', '*')); ?>

                                </label>
                                <input type="file" name="customer_agrement" accept="image/*" class="form-control-file"
                                    <?php if($r->clientsinfo->customer_agrement == null): ?> <?php echo e(checkRequired('customer_agrement_required', 'required')); ?> <?php endif; ?>>
                            </div>
                            <div class="form-group col-sm-2">
                                <div class="text-center mb-1 image-info"></div>
                                <?php if(checkSettings('store_image_to_s3') == 'enable'): ?>
                                    <?php
                                        $s3Url = Storage::disk('s3')->url(
                                            'profilePicture/' . $r->clientsinfo->profilePicture,
                                        );
                                    ?>

                                    <img width="auto" height="100" src="<?php echo e($s3Url); ?>" alt="No Image">
                                <?php else: ?>
                                    <img width="auto" height="100"
                                        src="<?php echo e(asset('storage/profilePicture/' . $r->clientsinfo->profilePicture)); ?>"
                                        alt="No Image">
                                <?php endif; ?>
                                <label for="profilePicture" class="block pt-2">
                                    Picture
                                </label>
                                <input type="file" name="profilePicture" accept="image/*" class="form-control-file">
                            </div>

                            <div class="form-group col-sm-2">
                                <div class="text-center mb-1 image-info"></div>
                                <?php if(checkSettings('store_image_to_s3') == 'enable'): ?>
                                    <?php
                                        $s3Url = Storage::disk('s3')->url('picture/' . $r->clientsinfo->picture);
                                    ?>

                                    <img width="auto" height="100" src="<?php echo e($s3Url); ?>" alt="No Image">
                                <?php else: ?>
                                    <img width="auto" height="100"
                                        src="<?php echo e(asset('storage/picture/' . $r->clientsinfo->picture)); ?>" alt="No Image">
                                <?php endif; ?>
                                <label for="picture" class="block pt-2">
                                    Building Photo<?php echo e(checkRequired('building_photo_required', '*')); ?>

                                </label>
                                <input type="file" name="picture" accept="image/*" class="form-control-file"
                                    <?php if($r->clientsinfo->picture == null): ?> <?php echo e(checkRequired('building_photo_required', 'required')); ?> <?php endif; ?>>
                            </div>

                            <div class="form-group col-sm-2">
                                <div class="text-center mb-1 image-info"></div>
                                <?php if(checkSettings('store_image_to_s3') == 'enable'): ?>
                                    <?php
                                        $s3Url = Storage::disk('s3')->url(
                                            'client_door/' . $r->clientsinfo->client_door,
                                        );
                                    ?>

                                    <img width="auto" height="100" src="<?php echo e($s3Url); ?>" alt="No Image">
                                <?php else: ?>
                                    <img width="auto" height="100"
                                        src="<?php echo e(asset('storage/client_door/' . $r->clientsinfo->client_door)); ?>"
                                        alt="No Image">
                                <?php endif; ?>
                                <label for="client_door" class="block pt-2">
                                    Client Flat Door Picture<?php echo e(checkRequired('dore_picture_required', '*')); ?>

                                </label>
                                <input type="file" name="client_door" accept="image/*" class="form-control-file"
                                    <?php if($r->clientsinfo->client_door == null): ?> <?php echo e(checkRequired('dore_picture_required', 'required')); ?> <?php endif; ?>>
                            </div>

                            <div class="form-group col-sm-2">
                                <div class="text-center mb-1 image-info"></div>
                                <?php if(checkSettings('store_image_to_s3') == 'enable'): ?>
                                    <?php
                                        $s3Url = Storage::disk('s3')->url(
                                            'onu_router_info/' . $r->clientsinfo->onu_router_info,
                                        );
                                    ?>

                                    <img width="auto" height="100" src="<?php echo e($s3Url); ?>" alt="No Image">
                                <?php else: ?>
                                    <img width="auto" height="100"
                                        src="<?php echo e(asset('storage/onu_router_info/' . $r->clientsinfo->onu_router_info)); ?>"
                                        alt="No Image">
                                <?php endif; ?>
                                <label for="onu_router_info" class="block pt-2">
                                    Onu and Router Info<?php echo e(checkRequired('onu_router_info', '*')); ?>

                                </label>
                                <input type="file" name="onu_router_info" accept="image/*" class="form-control-file"
                                    <?php if($r->clientsinfo->client_door == null): ?> <?php echo e(checkRequired('onu_router_info', 'required')); ?> <?php endif; ?>>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>

                <div class="bg-primary">
                    <h4 style="text-align: center;">Service Information</h4>
                </div>
                <?php if(checkAPI()): ?>
                    <div class="form-group">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ignore-mikrotik-check')): ?>
                            <label class="block">
                                Ignore Mikrotik Check <input name="ignoreMkCheck" type="checkbox"
                                    <?php echo e($r->ignoreMKCheck == 1 ? 'checked' : null); ?>>
                            </label>
                        <?php endif; ?>
                        <?php if(Auth::user()->can('static_manage')): ?>
                            <label class="block <?php if(!$r->isStatic): ?> d-none <?php endif; ?>">
                                Static IP <input name="isStatic" type="checkbox"
                                    <?php echo e($r->isStatic == 1 ? 'checked' : null); ?> disabled>
                            </label>
                        <?php endif; ?>

                    </div>
                <?php endif; ?>

                <div class="row">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pop_change_on_client_edit')): ?>
                        <div class="form-group col-sm-3">
                            <label for="pop_id">
                                Pop Name*
                            </label>
                            <select name="pop_id" id="pop_id" class="form-control select2">
                                <option value="">Select Pop</option>
                                <?php $__currentLoopData = $pop; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option class="p-5" value="<?php echo e($p->id); ?>"
                                        data-billgenerate="<?php echo e($p->bill_generate); ?>"
                                        <?php if($p->id == $r->pop_id): ?> selected <?php endif; ?>><?php echo e($p->popname); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['pop_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="alert alert-danger mt-1">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    <?php else: ?>
                        <div class="form-group col-sm-3">
                            <label for="pop_id">
                                Pop Name*
                            </label>
                            <input type="text" name="pop_name" id="pop_name" value="<?php echo e($r->pop->popname); ?>"
                                class="form-control " placeholder="Pop Name" readonly>
                            <input type="hidden" name="pop_id" id="pop_id" value="<?php echo e($r->pop_id); ?>">

                        </div>
                    <?php endif; ?>
                    <div class="form-group col-sm-3 <?php if($r->isStatic): ?> d-none <?php endif; ?>">
                        <label for="userid" class="">User Name*</label>
                        <input type="hidden" name="olduserid" id="olduserid" value="<?php echo e($r->userid); ?>">
                        <input type="text" name="userid" id="userid" value="<?php echo e($r->userid); ?>"
                            class="form-control" placeholder="User Name"
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('client-username-edit')): ?>
                                    readonly
                                <?php endif; ?>>
                        <div id="useridWarning"></div>
                        <?php $__errorArgs = ['userid'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"> <?php echo e($message); ?> </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group col-sm-3 <?php if($r->isStatic): ?> d-none <?php endif; ?>">
                        <label for="password" class="">
                            Password*
                        </label>
                        <input type="text" name="password" id="password" value="<?php echo e($r->password); ?>"
                            class="form-control " placeholder="Password">
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1">
                                <?php echo e($message); ?>

                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <?php if(checkSettings('customer_code') == 'enable'): ?>
                        <div class="form-group col-sm-3">
                            <label for="password" class="block text-sm font-medium text-gray-700">
                                Customer Code <?php if(checkSettings('customer_code') == 'enable'): ?>
                                    *
                                <?php endif; ?>
                            </label>
                            <input type="hidden" name="oldcustomer_code" id="oldcustomer_code"
                                value="<?php echo e($r->customer_code); ?>">
                            <input type="text" name="customer_code" id="customer_code"
                                value="<?php echo e($r->customer_code); ?>" class="form-control"
                                <?php if(checkSettings('customer_code') == 'enable'): ?> required <?php endif; ?> placeholder="customer code">
                            <div id="customerCodeWarning"></div>
                            <?php $__errorArgs = ['customer_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    <?php endif; ?>
                    <div class="form-group col-sm-3">
                        <label for="package_id" class="">
                            Package Name*
                        </label>
                        <input type="text" name="package_name" id="package_name"
                            value="<?php echo e($r->packages->package_name); ?>" class="form-control " placeholder="Package Name"
                            readonly>
                    </div>

                    <div class="form-group col-sm-3">
                        <label for="mac" class="">
                            Enable MAC
                        </label>
                        <input type="text" name="mac" id="mac" value="<?php echo e($r->mac ?? ''); ?>"
                            class="form-control " placeholder="Enable Mac">
                        <?php $__errorArgs = ['mac'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group col-sm-6">

                        <div class="row">
                            <div class="col-sm-6">
                                <label for="password" class="">
                                    Expired Date
                                </label>
                                <input type="text" name="expire_date" id="expire_date"
                                    value="<?php echo e($r->expire_date ?? ''); ?>" class="form-control " placeholder="Expire Date"
                                    readonly>
                            </div>

                            <?php if(auth()->user()->can('extend-temporary-dedline')): ?>
                                <?php if($r->pops->bill_generate == 'yes'): ?>
                                    <div class="col-sm-6">
                                        <label>
                                            Temporary Extend (days)
                                        </label>

                                        <input type="number" min="0"
                                            max="<?php echo e($company_information->max_extended_day ?? 30); ?>"
                                            name="payment_dadeline" class="form-control"
                                            placeholder="0 to <?php echo e($company_information->max_extended_day ?? 30); ?> days"
                                            value="<?php echo e($r->payment_dadeline); ?>">
                                    </div>
                                <?php endif; ?>
                            <?php else: ?>
                                <input type="hidden" name="payment_dadeline" value="<?php echo e($r->payment_dadeline); ?>"
                                    class="form-control">
                            <?php endif; ?>

                        </div>

                    </div>

                    <?php if(checkSettings('static_ip_manage') == 'enable' && $r->isStatic): ?>
                        <div class="form-group col-sm-3">
                            <label for="" class="block text-sm font-medium text-gray-700">
                                Interface / Ip Block
                            </label>
                            <select name="ethernet_port" id="port" class="form-control select2">
                                <option value="">Select Ethernet Port</option>
                                <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($data->id); ?>"
                                        <?php if($data->id == $r->ethernet_port): ?> selected <?php endif; ?>>
                                        <?php echo e($data->port); ?>-<?php echo e($data->ip_block); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <?php $__errorArgs = ['port'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="alert alert-danger mt-1">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    <?php endif; ?>

                    <div class="form-group col-sm-3">
                        <label for="client_name" class="block">
                            Static IP
                        </label>


                        <?php if(!checkAPI()): ?>
                            <input type="text" name="ip_address" id="ip_address" value="<?php echo e($r->ip_address); ?>"
                                class="form-control " placeholder="Static IP">
                            <?php $__errorArgs = ['ip_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <?php else: ?>
                            <?php if(checkSettings('static-ip-check') == 'enable'): ?>
                                <select class="form-control" name="ip_address" id="static_ip">
                                    <?php if(isset($r->ip_address)): ?>
                                        <option selected value="<?php echo e($r->ip_address); ?>"><?php echo e($r->ip_address); ?></option>
                                    <?php else: ?>
                                        <option selected value="">Select Static IP</option>
                                    <?php endif; ?>
                                    <?php echo $ip; ?>

                                </select>
                            <?php elseif(checkSettings('static_ip_manage') == 'enable'): ?>
                                <select class="form-control" name="ip_address" id="static_ip">
                                    <?php if(isset($r->ip_address)): ?>
                                        <option selected value="<?php echo e($r->ip_address); ?>"><?php echo e($r->ip_address); ?></option>
                                    <?php else: ?>
                                        <option selected value="">Select Static IP</option>
                                    <?php endif; ?>
                                    <?php echo $ip; ?>

                                </select>
                            <?php else: ?>
                                <input type="text" name="ip_address" id="ip_address" value="<?php echo e($r->ip_address); ?>"
                                    class="form-control " placeholder="Static IP">
                                <?php $__errorArgs = ['ip_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <?php endif; ?>

                        <?php endif; ?>

                    </div>

                    <?php if(checkSettings('ipv_6_for_radius') == 'enable'): ?>
                        <div class="form-group col-sm-3">
                            <label for="mac" class="block">
                                Static Ip of IPv6 (if any)
                            </label>

                            <input type="text" name="ipv6" id="ip6" value="<?php echo e($r->ipv6 ?? ''); ?>"
                                class="form-control " placeholder="Enter ipv6" autocomplete="off">
                            <?php $__errorArgs = ['ipv6'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                        </div>
                    <?php endif; ?>

                    <?php if(checkSettings('radius_customer_bandwidth_limit') == 'enable'): ?>
                        <?php if(auth()->user()->can('apply-bandwidth-limit')): ?>
                            <div class="form-group col-sm-3" id="">
                                <label for="bandwidth_limit" class="block">
                                    Bandwidth Limit Extra (MB)
                                </label>
                                <input type="number" step=".01" name="bandwidth_limit" id="bandwidth_limit"
                                    value="<?php echo e($r->bandwidth_limit); ?>" class="form-control "
                                    placeholder="Bandwidth Limit Extra In MB">
                                <?php $__errorArgs = ['bandwidth_limit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        <?php else: ?>
                            <input type="hidden" name="bandwidth_limit" id="bandwidth_limit"
                                value="<?php echo e($r->bandwidth_limit); ?>" readonly class="form-control"
                                placeholder="Bandwidth Limit">
                        <?php endif; ?>
                    <?php endif; ?>

                    <?php if(checkSettings('parmanent-discount') == 'enable' && $r->pop->bill_generate == 'yes'): ?>
                        <?php if(auth()->user()->can('parmanent-discount')): ?>
                            <div class="form-group col-sm-3">
                                <label for="mac" class="block ">
                                    Parmanent Discount Amount
                                </label>

                                <input type="text" name="parmanent_discount" value="<?php echo e($r->parmanent_discount); ?>"
                                    class="form-control " placeholder="Discount Amount">
                                <?php $__errorArgs = ['mac'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        <?php else: ?>
                            <input type="hidden" name="parmanent_discount" value="<?php echo e($r->parmanent_discount); ?>"
                                class="form-control">
                        <?php endif; ?>
                    <?php endif; ?>

                    <?php if(checkSettings('customer-id-insert') == 'enable'): ?>
                        <div class="form-group col-sm-3" id="customer_id">
                            <label for="client_name" class="block">
                                Customer ID
                            </label>

                            <input type="text" name="customer_id" id="customer_id" value="<?php echo e($r->customer_id); ?>"
                                class="form-control " placeholder="Customer ID" required>
                            <?php $__errorArgs = ['customer_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    <?php endif; ?>

                    <div class="form-group col-sm-3">
                        <label for="distribution_point" class="block">
                            Distribution Point <?php if(checkSettings('btrc_report_field_required') == 'enable'): ?>
                                *
                            <?php endif; ?>
                        </label>
                        <select name="distribution_point" id="" class="form-control select2"
                            <?php if(checkSettings('btrc_report_field_required') == 'enable'): ?> required <?php endif; ?>>
                            <option value="">Select One</option>
                            <option value="pop" <?php echo e($r->distribution_point == 'pop' ? 'selected' : ''); ?>>POP</option>
                            <option value="noc" <?php echo e($r->distribution_point == 'noc' ? 'selected' : ''); ?>>NOC</option>
                        </select>
                        <?php $__errorArgs = ['distribution_point'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="connection_type" class="block">
                            Connection Type <?php if(checkSettings('btrc_report_field_required') == 'enable'): ?>
                                *
                            <?php endif; ?>
                        </label>
                        <select name="connection_type" id="" class="form-control select2"
                            <?php if(checkSettings('btrc_report_field_required') == 'enable'): ?> required <?php endif; ?>>
                            <option value="">Select One</option>
                            <option value="shared" <?php echo e($r->connection_type == 'shared' ? 'selected' : ''); ?>>Shared</option>
                            <option value="dedicated" <?php echo e($r->connection_type == 'dedicated' ? 'selected' : ''); ?>>Dedicated
                            </option>
                        </select>
                        <?php $__errorArgs = ['connection_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="customer_type" class="block">Client Type <?php if(checkSettings('btrc_report_field_required') == 'enable'): ?>
                                *
                            <?php endif; ?>
                        </label>
                        <select name="customer_type" id="" class="form-control select2"
                            <?php if(checkSettings('btrc_report_field_required') == 'enable'): ?> required <?php endif; ?>>
                            <option value="">Select One</option>
                            <option value="Home" <?php echo e($r->customer_type == 'Home' ? 'selected' : ''); ?>>Home</option>
                            <option value="Corporate" <?php echo e($r->customer_type == 'Corporate' ? 'selected' : ''); ?>>Corporate
                            </option>
                        </select>
                        <?php $__errorArgs = ['customer_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="bg-primary">
                    <h4 style="text-align: center;">Basic Information</h4>
                </div>
                <div class="row">

                    <div class="form-group col-sm-3">
                        <label for="password" class="">
                            Client Name*
                        </label>
                        <input type="text" name="client_name" id="client_name" required
                            value="<?php echo e($r->clientsinfo->clients_name); ?>" class="form-control " placeholder="Client Name">
                        <?php $__errorArgs = ['client_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <?php if(auth()->user()->can('join-date-modify')): ?>
                        <div class="form-group col-sm-3">
                            <label for="joinDate" class="">
                                Joining Date
                            </label>
                            <div class="input-group date" id="searchFrom2" data-target-input="nearest">
                                <input type="text" placeholder="Joining Date" name="joinDate"
                                    value="<?php echo e($r->clientsinfo->joinDate); ?>"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchFrom2" autocomplete="off">
                            </div>
                            <?php $__errorArgs = ['joinDate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    <?php else: ?>
                        <input type="hidden" name="joinDate" value="<?php echo e($r->clientsinfo->joinDate ?? ''); ?>"
                            class="form-control">
                    <?php endif; ?>

                    <div class="form-group col-sm-3">
                        <label for="password" class="block ">
                            Client DOB
                        </label>
                        <div class="input-group date" id="searchFrom" data-target-input="nearest">
                            <input type="text" placeholder="Client DOB" name="dob"
                                value="<?php echo e($r->clientsinfo->dob); ?>"
                                class="form-control datetimepicker-input input-group-append" data-toggle="datetimepicker"
                                data-target="#searchFrom" autocomplete="off">
                        </div>
                        <?php $__errorArgs = ['dob'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="father_name" class="">
                            Father Name<?php echo e(checkRequired('father-name-required', '*')); ?>

                        </label>
                        <input type="text" name="father_name" id="father_name"
                            value="<?php echo e($r->clientsinfo->father_name ?? ''); ?>" class="form-control "
                            placeholder="Father Name" <?php echo e(checkRequired('father-name-required', '*')); ?>>
                        <?php $__errorArgs = ['father_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="mother_name" class="">
                            Mother Name <?php echo e(checkRequired('mother-name-required', '*')); ?>

                        </label>
                        <input type="text" name="mother_name" id="mother_name"
                            value="<?php echo e($r->clientsinfo->mother_name ?? ''); ?>" class="form-control "
                            placeholder="Mother Name" <?php echo e(checkRequired('mother-name-required', 'required')); ?>>
                        <?php $__errorArgs = ['mother_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="contact_no" class="">
                            Contact No*
                        </label>
                        <input type="text" name="contact_no" id="contact_no" required
                            value="<?php echo e($r->clientsinfo->contact_no ?? ''); ?>" class="form-control "
                            placeholder="Contact No">
                        <?php $__errorArgs = ['contact_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group col-sm-3">
                        <label for="contact_no" class="block">
                            Other Contact No
                        </label>
                        <input type="text" name="other_contact" id="other_contact"
                            value="<?php echo e($r->clientsinfo->other_contact ?? ''); ?>" class="form-control "
                            placeholder="Other Contact No">
                        <?php $__errorArgs = ['other_contact'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group col-sm-3">
                        <label for="email" class="">
                            Email
                        </label>
                        <input type="text" class="form-control" placeholder="email"
                            value="<?php echo e($r->clientsinfo->email ?? ''); ?>" data-role="tagsinput" id="tags"
                            name="email">
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group col-sm-3">
                        <label for="national_id" class="">
                            National ID <?php if(checkSettings('national_id') == 'enable'): ?>
                                *
                            <?php endif; ?>
                        </label>
                        <input type="text" name="national_id" id="national_id"
                            value="<?php echo e($r->clientsinfo->national_id ?? ''); ?>" class="form-control "
                            <?php if(checkSettings('national_id') == 'enable'): ?> required <?php endif; ?> placeholder="National ID">
                        <?php $__errorArgs = ['national_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <?php if(checkSettings('national_id_picture') == 'enable'): ?>
                        <div class="form-group col-sm-3">
                            <label for="nid_image">National ID Image
                                <?php echo e(checkRequired('national_id_picture', '*')); ?></label>
                            <?php if(checkSettings('store_image_to_s3') == 'enable'): ?>
                                <?php
                                    $s3Url = Storage::disk('s3')->url('nationalId/' . $r->clientsinfo->nid_image);
                                ?>
                                <img width="auto" height="100" src="<?php echo e($s3Url); ?>" alt="No Image">
                            <?php else: ?>
                                <img width="auto" height="100"
                                    src="<?php echo e(asset('storage/nationalId/' . $r->clientsinfo->nid_image)); ?>"
                                    alt="No Image">
                            <?php endif; ?>
                            <input type="file" name="nid_image" accept="image/*" class="form-control-file"
                                <?php if($r->clientsinfo->nid_image == null): ?> <?php echo e(checkRequired('national_id_picture', 'required')); ?> <?php endif; ?>>
                            <?php $__errorArgs = ['nid_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    <?php endif; ?>

                    <div class="form-group col-sm-3">
                        <label for="passport_no" class="">
                            Passport No
                        </label>
                        <input type="text" name="passport_no" id="passport_no"
                            value="<?php echo e($r->clientsinfo->passport_no ?? ''); ?>" class="form-control "
                            placeholder="Passport No">
                        <?php $__errorArgs = ['passport_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="bg-primary">
                    <h4 style="text-align: center;">Address</h4>
                </div>
                <div class="row">

                    <div class="col-sm-3">
                        <label for="division" class="block pt-2">
                            Division <?php echo e(checkSettings('Division') == 'enable' ? '*' : ''); ?>

                        </label>
                        <select name="division" id="division_id" class="form-control select2"
                            <?php echo e(checkSettings('Division') == 'enable' ? 'required' : ''); ?>>
                            <option value="">Select One</option>
                            <?php $__empty_1 = true; $__currentLoopData = $division; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <option value="<?php echo e($item->id); ?>"
                                    <?php echo e($item->id == $r->clientsinfo->division ? 'selected' : ''); ?>>
                                    <?php echo e($item->name); ?>- <?php echo e($item->bn_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <option value="">No Division Found</option>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="col-sm-3">
                        <label for="district" class="block pt-2">
                            District <?php echo e(checkSettings('District') == 'enable' ? '*' : ''); ?>

                        </label>
                        <select name="district" id="district_id" class="form-control select2"
                            <?php echo e(checkSettings('District') == 'enable' ? 'required' : ''); ?>>
                            <option value="">Select One</option>
                            <?php if(!empty($r->clientsinfo->district)): ?>
                                <?php $__currentLoopData = $district; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>"
                                        <?php echo e($item->id == $r->clientsinfo->district ? 'selected' : ''); ?>>
                                        <?php echo e($item->name); ?>- <?php echo e($item->bn_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="col-sm-3">
                        <label for="upazila" class="block pt-2">
                            Upazila <?php echo e(checkSettings('Upazila') == 'enable' ? '*' : ''); ?>

                        </label>
                        <select name="upazila" id="upazila_id" class="form-control select2"
                            <?php echo e(checkSettings('Upazila') == 'enable' ? 'required' : ''); ?>>
                            <option value="">Select One</option>

                            <?php if(!empty($r->clientsinfo->upazila)): ?>
                                <?php $__currentLoopData = $upazila; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>"
                                        <?php echo e($item->id == $r->clientsinfo->upazila ? 'selected' : ''); ?>>
                                        <?php echo e($item->name); ?>- <?php echo e($item->bn_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            </option>
                        </select>
                    </div>
                    <div class="col-sm-3">
                        <label for="thana" class="block pt-2">
                            Thana <?php echo e(checkSettings('Thana') == 'enable' ? '*' : ''); ?>

                        </label>
                        <select name="thana" id="thana_id" class="form-control select2"
                            <?php echo e(checkSettings('Thana') == 'enable' ? 'required' : ''); ?>>
                            <option value="">Select One</option>

                            
                            <?php $__currentLoopData = $thana; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id); ?>"
                                    <?php echo e($item->id == $r->clientsinfo->thana ? 'selected' : ''); ?>>
                                    <?php echo e($item->name); ?>- <?php echo e($item->bn_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            
                            </option>
                        </select>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="area" class="pt-2">
                            Area/Union Parishad <?php if(checkSettings('area') == 'enable'): ?>
                                *
                            <?php endif; ?>
                        </label>
                        <?php if(checkSettings('area-dropdown') == 'enable'): ?>
                            <select class="form-control select2" name="area" id="area"
                                <?php echo e(checkSettings('area') == 'enable' ? 'required' : ''); ?>>
                                <option value="">Select One</option>
                                <?php $__empty_1 = true; $__currentLoopData = $popArea; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <option value="<?php echo e($item->area); ?>"
                                        <?php echo e($r->clientsinfo->area == $item->area ? 'selected' : ''); ?>>
                                        <?php echo e($item->area); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php endif; ?>
                            </select>
                        <?php else: ?>
                            <select name="area_select" id="area_select" class="select2 form-control">
                                <option value="">Select Area</option>
                                <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($area); ?>"><?php echo e($area); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <input type="text" name="area" id="area"
                                value="<?php echo e($r->clientsinfo->area ?? ''); ?>" class="form-control float-right"
                                placeholder="Area">
                        <?php endif; ?>
                        <?php $__errorArgs = ['area'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="block_sector" class="pt-2">
                            Block/Sector/Post Office
                        </label>
                        <input type="text" name="block_sector" id="block_sector"
                            value="<?php echo e($r->clientsinfo->block_sector ?? ''); ?>" class="form-control "
                            placeholder="Block/Sector">
                        <?php $__errorArgs = ['block_sector'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?>

                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="road_name" class="pt-2">
                            Road Name/Village
                        </label>
                        <input type="text" name="road_name" id="road_name"
                            value="<?php echo e($r->clientsinfo->road_name ?? ''); ?>" class="form-control "
                            placeholder="Road Name">
                        <?php $__errorArgs = ['road_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="road_no" class="pt-2">
                            Road No/Ward No
                        </label>
                        <input type="text" name="road_no" id="road_no"
                            value="<?php echo e($r->clientsinfo->road_no ?? ''); ?>" class="form-control " placeholder="Road No">
                        <?php $__errorArgs = ['road_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="building_name" class="">
                            Building Name<?php echo e(checkRequired('bulling_name', '*')); ?>

                        </label>
                        <input type="text" name="building_name" id="building_name"
                            value="<?php echo e($r->clientsinfo->building_name ?? ''); ?>" class="form-control "
                            placeholder="Building Name" <?php echo e(checkRequired('bulling_name', 'required')); ?>>
                        <?php $__errorArgs = ['building_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?>

                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="password" class="">
                            Building No
                        </label>
                        <input type="text" name="building_no" id="building_no"
                            value="<?php echo e($r->clientsinfo->building_no ?? ''); ?>" class="form-control "
                            placeholder="Building No">
                        <?php $__errorArgs = ['building_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="flat_no" class="">
                            Flat/Level No<?php echo e(checkRequired('flat_no', '*')); ?>

                        </label>
                        <input type="text" name="flat_no" id="flat_no"
                            value="<?php echo e($r->clientsinfo->flat_no ?? ''); ?>" class="form-control " placeholder="Flat No"
                            <?php echo e(checkRequired('flat_no', '*')); ?>>
                        <?php $__errorArgs = ['flat_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group col-sm-3">
                        <label for="owner_name" class="">
                            House Owner Name<?php echo e(checkRequired('house_owner_name', '*')); ?>

                        </label>
                        <input type="text" name="owner_name" id="owner_name"
                            value="<?php echo e($r->clientsinfo->owner_name); ?>" class="form-control " placeholder="Owner Name"
                            <?php echo e(checkRequired('house_owner_name', 'required')); ?>>
                        <?php $__errorArgs = ['owner_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="owner_contact" class="block">
                            Owner Contact<?php echo e(checkRequired('house_owner_contact', '*')); ?>

                        </label>
                        <input type="text" name="owner_contact" id="onwer_number"
                            value="<?php echo e($r->clientsinfo->owner_number); ?>" class="form-control "
                            placeholder="Owner Contact" <?php echo e(checkRequired('house_owner_contact', 'required')); ?>>
                        <?php $__errorArgs = ['onwer_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger mt-1"><?php echo e($message); ?>

                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <?php if(checkSettings('box') == 'disable'): ?>
                        <div class="col-sm-3">
                            <label for="area" class="block">
                                Box
                            </label>
                            <input type="text" name="box" id="box" value="<?php echo e($r->clientsinfo->box); ?>"
                                class="form-control " placeholder="box">
                        </div>
                    <?php endif; ?>
                    <?php if(checkSettings('box') == 'enable'): ?>
                        <div class="col-sm-3">
                            <label class="block">
                                Box id
                            </label>
                            <select name="box_id" id="box_id" class="form-control">
                                <option value="">Select Box</option>
                                <?php $__currentLoopData = $boxs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>"
                                        <?php echo e($item->id == $r->box_id ? 'selected' : ''); ?>>
                                        <?php echo e($item->box_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    <?php endif; ?>

                    <?php if(globalPermission('manage-map')): ?>
                        <div class="col-sm-3">
                            <label for="map_box_id" class="block">
                                Map Box
                            </label>
                            <select name="map_box_id" id="map_box" class="form-control select2">

                            </select>
                        </div>
                    <?php endif; ?>

                    <div class="col-sm-3">
                        <label for="latitude" class="block">
                            Latitude
                        </label>
                        <input type="text" name="client_latitude" id="client_latitude"
                            value="<?php echo e($r->clientsinfo->client_latitude); ?>" class="form-control "
                            placeholder="latitude">
                    </div>
                    <div class="col-sm-3">
                        <label for="longitude" class="block">
                            Longitude
                        </label>
                        <input type="text" name="client_longitude" id="client_longitude"
                            value="<?php echo e($r->clientsinfo->client_longitude); ?>" class="form-control "
                            placeholder="longitude">
                    </div>
                </div>

                <div class="bg-primary mt-3">
                    <h4 style="text-align: center;">Connection Information</h4>
                </div>
                <div class="row">

                    <div class="row" id="connection_info">
                        <div class="form-group col-sm-2">
                            <label for="passport_no" class="block pt-2">
                                Cable type<?php echo e(checkRequired('cable-meter-required', '*')); ?>

                            </label>
                            <select name="cable_type" id="cable_type" class="form-control form-control-sm select2"
                                <?php echo e(checkRequired('cable_meter_required', 'required')); ?>>
                                <option value="">Select Cable Core Type</option>
                                <option value="fiber_optic_2_core" <?php if($r->clientsinfo->cable_type == 'fiber_optic_2_core'): ?> selected <?php endif; ?>>
                                    Fiber
                                    Optic 2 Core
                                </option>
                                <option value="fiber_optic_4_core" <?php if($r->clientsinfo->cable_type == 'fiber_optic_4_core'): ?> selected <?php endif; ?>>
                                    Fiber
                                    Optic 4 Core
                                </option>
                                <option value="fiber_optic_6_core" <?php if($r->clientsinfo->cable_type == 'fiber_optic_6_core'): ?> selected <?php endif; ?>>
                                    Fiber
                                    Optic 6 Core
                                </option>
                                <option value="fiber_optic_8_core" <?php if($r->clientsinfo->cable_type == 'fiber_optic_8_core'): ?> selected <?php endif; ?>>
                                    Fiber Optic 8 Core
                                </option>
                                <option value="fiber_optic_12_core" <?php if($r->clientsinfo->cable_type == 'fiber_optic_12_core'): ?> selected <?php endif; ?>>
                                    Fiber Optic 12 Core
                                </option>
                                <option value="fiber_optic_24_core" <?php if($r->clientsinfo->cable_type == 'fiber_optic_24_core'): ?> selected <?php endif; ?>>
                                    Fiber Optic 24 Core
                                </option>
                            </select>
                        </div>

                        <?php if(auth()->user()->can('edit_cable_meter')): ?>
                            <div class="form-group col-sm-1">
                                <label for="from_cable"
                                    class="block pt-2">From:<?php echo e(checkRequired('cable_meter_from', '*')); ?></label>
                                <input type="number" min="0" name="from_cable" id="from_cable"
                                    value="<?php echo e($r->clientsinfo->from_cable); ?>" class="form-control form-control-sm "
                                    placeholder="Start Number" <?php echo e(checkRequired('cable_meter_from', 'required')); ?>>
                            </div>
                            <div class="form-group col-sm-1">
                                <label for="to_cable"
                                    class="block pt-2">To:<?php echo e(checkRequired('cable_meter_to', '*')); ?></label>
                                <input type="number" min="0" name="to_cable" id="to_cable"
                                    value="<?php echo e($r->clientsinfo->to_cable); ?>" class="form-control form-control-sm "
                                    placeholder="End Number" <?php echo e(checkRequired('cable_meter_to', 'required')); ?>>
                            </div>
                            <div class="form-group col-sm-1">
                                <label for="from_cable2" class="block pt-2">From(2nd):</label>
                                <input type="number" min="0" name="from_cable2" id="from_cable2"
                                    value="<?php echo e($r->clientsinfo->from_cable2); ?>" class="form-control form-control-sm "
                                    placeholder="Start Number">
                            </div>
                            <div class="form-group col-sm-1">
                                <label for="to_cable2" class="block pt-2">To(2nd):</label>
                                <input type="number" min="0" name="to_cable2" id="to_cable2"
                                    value="<?php echo e($r->clientsinfo->to_cable2); ?>" class="form-control form-control-sm "
                                    placeholder="End Number">
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="total" class="block pt-2">Total Cable(Meter)</label>
                                <input type="text" value="<?php echo e($r->required_cable); ?>" id="total_cable_meter"
                                    name="required_cable" class="form-control form-control-sm">
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="cable_id" class="block pt-2">Cable ID
                                    <?php echo e(checkRequired('cable_id_required', '*')); ?></label>
                                <input type="text" name="cable_id" id="cable_id"
                                    value="<?php echo e($r->clientsinfo->cable_id ?? ''); ?>" class="form-control  form-control-sm"
                                    placeholder="Cable ID" <?php echo e(checkRequired('cable_id_required', 'required')); ?>>
                                <?php $__errorArgs = ['cable_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        <?php else: ?>
                            <input type="hidden" name="from_cable" value="<?php echo e($r->clientsinfo->from_cable ?? ''); ?>"
                                class="form-control">
                            <input type="hidden" name="to_cable" value="<?php echo e($r->clientsinfo->to_cable ?? ''); ?>"
                                class="form-control">
                            <input type="hidden" name="from_cable2" value="<?php echo e($r->clientsinfo->from_cable2 ?? ''); ?>"
                                class="form-control">
                            <input type="hidden" name="to_cable2" value="<?php echo e($r->clientsinfo->to_cable2 ?? ''); ?>"
                                class="form-control">
                            <input type="hidden" name="required_cable" value="<?php echo e($r->required_cable ?? ''); ?>"
                                class="form-control">
                            <input type="hidden" name="cable_id" value="<?php echo e($r->clientsinfo->cable_id ?? ''); ?>"
                                class="form-control">
                        <?php endif; ?>

                        <div class="form-group col-sm-2">
                            <label for="cat_type" class="block pt-2">
                                Cable(CAT-5/CAT-6)<?php echo e(checkRequired('cable_cat5_cat6_required', '*')); ?>

                            </label>
                            <select name="cat_type" id="cat_type" class="form-control select2 form-control-sm"
                                <?php echo e(checkRequired('cable_cat5_cat6_required', 'required')); ?>>
                                <option value="">Select Cable Type</option>
                                <option value="cat5" <?php echo e($r->clientsinfo->cat_type == 'cat5' ? 'selected' : ''); ?>>
                                    Cat 5
                                </option>
                                <option value="cat6" <?php echo e($r->clientsinfo->cat_type == 'cat6' ? 'selected' : ''); ?>>
                                    Cat 6
                                </option>
                            </select>
                        </div>

                        <div class="form-group col-sm-3">
                            <label for="cat_length" class="block pt-2">
                                Cable(CAT-5/CAT-6) Meter <?php echo e(checkRequired('cable_cat5_cat6_required', '*')); ?>

                            </label>
                            <input type="number" min="0" name="cat_length" id="cat_length"
                                value="<?php echo e($r->clientsinfo->cat_length); ?>" class="form-control  form-control-sm"
                                placeholder="Cable Meter" <?php echo e(checkRequired('cable_cat5_cat6_required', 'required')); ?>>
                            <?php $__errorArgs = ['cat_length'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <?php if(checkSettings('olt-pon') == 'enable'): ?>
                            <div class="form-group col-sm-3">
                                <label for="onu_serial" class="block pt-2">
                                    ONU MAC/Pon No/Serial No <?php echo e(checkRequired('onu_serial_required', '*')); ?>

                                </label>
                                <input type="text" name="onu_serial" id="onu_serial"
                                    value="<?php echo e($r->clientsinfo->onu_serial ?? ''); ?>"
                                    class="form-control  form-control-sm" placeholder="ONU MAC/Serial No"
                                    <?php echo e(checkRequired('onu_serial_required', 'required')); ?>>
                                <?php $__errorArgs = ['onu_serial'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group col-sm-3">
                                <label for="olt_pon" class="block pt-2">
                                    OLT No <?php echo e(checkRequired('olt_no_require', '*')); ?>

                                </label>
                                <input type="text" name="olt_pon" id="olt_pon"
                                    value="<?php echo e($r->clientsinfo->olt_pon ?? ''); ?>" class="form-control  form-control-sm"
                                    placeholder="Olt No" <?php echo e(checkRequired('olt_no_require', 'required')); ?>>
                                <?php $__errorArgs = ['olt_pon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group col-sm-3">
                                <label for="olt_no" class="block pt-2">
                                    OLT Card Slot Number <?php echo e(checkRequired('olt_port_number_required', '*')); ?>

                                </label>
                                <input type="text" name="olt_no" id="olt_no"
                                    value="<?php echo e($r->clientsinfo->olt_no); ?>" class="form-control form-control-sm "
                                    placeholder="OLT Card Slot Number"
                                    <?php echo e(checkRequired('olt_port_number_required', 'required')); ?>>
                                <?php $__errorArgs = ['olt_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group col-sm-3">
                                <label for="pon_port" class="block pt-2">
                                    PON Module Port No <?php echo e(checkRequired('pon_module_required', '*')); ?>

                                </label>
                                <input type="text" name="pon_port" id="pon_port"
                                    value="<?php echo e($r->clientsinfo->pon_port); ?>" class="form-control"
                                    placeholder="PON Module Port No"
                                    <?php echo e(checkRequired('pon_module_required', 'required')); ?>>
                                <?php $__errorArgs = ['pon_port'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        <?php endif; ?>

                        <?php if(auth()->user()->can('customer-marketed-by')): ?>
                            <div class="form-group col-sm-3">
                                <label for="marketed_by" class="block pt-2">
                                    Marketed By <?php echo e(checkRequired('marketed_by_required', '*')); ?>

                                </label>
                                <?php if(auth()->user()->can('change_marketed_by')): ?>
                                    <div class="col-sm-12" id="marketedDiv">
                                        <select name="marketed_by" id="marketed_by" class="form-control select2"
                                            <?php echo e(checkRequired('marketed_by_required', 'required')); ?>>
                                            <option value="">Select Marketer</option>
                                            <?php $__empty_1 = true; $__currentLoopData = $marketer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <option value="<?php echo e($m->id); ?>"
                                                    <?php echo e($m->id == $r->marketed_by ? 'selected' : ''); ?>>
                                                    <?php echo e($m->firstname); ?>

                                                    <?php echo e($m->lastname); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                <?php else: ?>
                                    <input type="hidden" name="marketed_by" value="<?php echo e($r->marketed_by ?? ''); ?>"
                                        class="form-control">
                                    <div class="col-sm-12">
                                        <select class="form-control" disabled>
                                            <option value="">Select One</option>
                                            <?php $__empty_1 = true; $__currentLoopData = $marketer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <option value="<?php echo e($m->id); ?>"
                                                    <?php echo e($m->id == $r->marketed_by ? 'selected' : ''); ?>>
                                                    <?php echo e($m->firstname); ?>

                                                    <?php echo e($m->lastname); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                <?php endif; ?>
                                
                            </div>
                        <?php else: ?>
                            <input type="hidden" name="marketed_by" value="<?php echo e($r->marketed_by ?? ''); ?>"
                                class="form-control">
                        <?php endif; ?>
                        <?php if(checkSettings('source_name') == 'enable'): ?>
                            <div class="form-group col-sm-3">
                                <label for="marketed_by" class="block pt-2">
                                    Source Name
                                </label>
                                <div class="" id="">
                                    <select name="source_name" id="source_name" class="form-control select2">
                                        <option value="">Select One</option>
                                        <?php $__empty_1 = true; $__currentLoopData = $client_source; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $source): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <option value="<?php echo e($source->id); ?>"
                                                <?php echo e($r->clientsinfo->source_name == $source->id ? 'selected' : ''); ?>>
                                                <?php echo e($source->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <?php $__errorArgs = ['source_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        <?php endif; ?>
                        <div class="form-group col-sm-3">
                            <label for="required_cable" class="block pt-2">OTC</label>
                            <input type="text" min="0" name="otc" id="otc"
                                value="<?php echo e($r->clientsinfo->otc ?? ''); ?>" class="form-control " placeholder="otc"
                                readonly>
                            <?php $__errorArgs = ['otc'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="alert alert-danger mt-1"><?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <?php if(checkSettings('free_client') == 'enable'): ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('free-client')): ?>
                                <div class="form-group col-sm-3">
                                    <label for="billing_cycle" class="block pt-2">
                                        Free CLient
                                    </label>
                                    <select name="is_free" id="is_free" class="form-control" required>
                                        <option <?php echo e($r->is_free == 0 ? 'selected' : ''); ?> value="0">No</option>
                                        <option <?php echo e($r->is_free == 1 ? 'selected' : ''); ?> value="1">Yes</option>
                                    </select>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>

                        <div class="form-group col-sm-3">
                            <label for="billing_cycle" class="block pt-2">
                                Remote Access
                            </label>
                            <select name="remote_access" id="remote_access" class="form-control" required>
                                <option value="No" <?php echo e($r->remote_access == 'No' ? 'selected' : ''); ?>>No</option>
                                <option value="Yes" <?php echo e($r->remote_access == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                            </select>
                        </div>
                        <div class="form-group col-sm-3">
                            <label for="billing_cycle" class="block pt-2">
                                Remote Access Username
                            </label>
                            <input type="text" name="remote_access_username" id="remote_access_username"
                                class="form-control" placeholder="Remote Access Username"
                                value="<?php echo e($r->remote_access_username); ?>">
                            <?php $__errorArgs = ['remote_access_username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group col-sm-3">
                            <label for="billing_cycle" class="block pt-2">
                                Remote Access Password
                            </label>
                            <input type="text" name="remote_access_password" id="remote_access_password"
                                class="form-control" placeholder="Remote Access Password"
                                value="<?php echo e($r->remote_access_password); ?>">
                            <?php $__errorArgs = ['remote_access_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group col-sm-3">
                            <label for="billing_cycle" class="block pt-2">
                                Remote Access Port
                            </label>
                            <input type="text" name="remote_access_port" id="remote_access_port" class="form-control"
                                placeholder="Remote Access Port" value="<?php echo e($r->remote_access_port); ?>">
                            <?php $__errorArgs = ['remote_access_port'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <?php if(globalPermission('manage-line-man')): ?>
                            <div class="form-group col-sm-3">
                                <label for="billing_cycle" class="block pt-2">
                                    Line Man *
                                </label>
                                <select name="line_man_id" id="line_man_id" class="form-control select2" required>
                                    <option value="">Select Line Man</option>
                                    <?php $__empty_1 = true; $__currentLoopData = $line_mans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $line_man): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <option value="<?php echo e($line_man->id); ?>" <?php echo e($r->line_man_id == $line_man->id ? 'selected' : ''); ?>><?php echo e($line_man->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <option value="">No Line Man Found</option>
                                    <?php endif; ?>
                                </select>
                                <?php $__errorArgs = ['line_man_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        <?php endif; ?>
                        <?php if(checkSettings('setClientPaymentAmountToClient') == 'enable'): ?>
                            <div class="form-group col-md-4" id="clientPaymentContainer"
                                style="display: <?php if($r->pops->bill_generate != 'yes'): ?> <?php else: ?> none <?php endif; ?>">
                                <label for="pool_name" class="block text-sm font-medium text-gray-700">
                                    Client payment amount
                                </label>
                                <input type="number" name="client_payment_amount" id="client_payment_amount"
                                    class="focus:ring-indigo-500 focus:border-indigo-500 form-control"
                                    placeholder=" Client payment amount" value="<?php echo e($r->client_payment_amount); ?>"
                                    autocomplete="off">
                                <?php $__errorArgs = ['client_payment_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger">
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        <?php endif; ?>
                        <div class="form-group col-sm-12">
                            <label for="contact_no" class="">Remarks</label>
                            <textarea name="remarks" id="remarks" class="form-control"><?php echo e($r->clientsinfo->remarks ?? ''); ?></textarea>
                            <?php $__errorArgs = ['remarks'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="alert alert-danger mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <div class="form-group col-sm-4 float-right">
                    <div class="mt-5 mr-1 row float-right">
                        <a href="<?php echo e(route('clients.index')); ?>"><button type="button"
                                class="btn btn-primary">Back</button></a>
                        <button type="submit" id="updateBtn" class="btn btn-success ml-1">Update Client
                            Info</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <div class="modal fade" id="mapModal" tabindex="-1" role="dialog" aria-labelledby="mapModalLabel">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="mapModalLabel">Select Client Location</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div id="map" style="height:500px;"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="save-location-btn">Save Location</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="imageModal" tabindex="-1" role="dialog" aria-labelledby="imageModalLabel">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="imageModalLabel">Image Preview</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body text-center">
                    <img id="modalImage" src="" alt="Full size image" style="max-width: 100%; height: auto;">
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('taginput/bootstrap-tagsinput.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('ajax'); ?>
    <script type="text/javascript">
        $(function() {

            $('#paymentDate').datetimepicker({
                format: 'L'
            });

            var macAddress = $("#mac");

            macAddress.on("keyup", formatMAC);

            $('#port').on('change', function() {
                let pop = $('#pop_id').val();
                let id = $(this).val();
                $.ajax({
                    type: 'get',
                    url: '<?php echo e(route('getStaticIpRange')); ?>',
                    data: {
                        id: id,
                        pop: pop
                    },
                    success: function(data) {
                        $('#static_ip').html(
                            '<option value="<?php echo e($r->ip_address); ?>"><?php echo e($r->ip_address); ?></option>' +
                            data
                        );
                    }
                });

            });

            $('#userid').on('change', function() {
                let olduserid = $('#olduserid').val();
                let userid = $(this).val();

                if (olduserid == userid) {
                    $('#updateBtn').show();
                    $('#userid').css('border', '1px solid #ddd');
                    $('#useridWarning').html('<span></span>');
                } else {

                    $.ajax({
                        type: 'get',
                        url: '<?php echo e(route('checkUsernameOnEdit')); ?>',
                        data: {
                            username: userid
                        },
                        success: function(data) {

                            if (data != true) {

                                $('#updateBtn').hide();
                                $('#userid').css('border', '1px solid red');
                                $('#useridWarning').html(
                                    '<span style="color:red">Not Available</span>');
                            } else {
                                $('#updateBtn').show();
                                $('#userid').css('border', '1px solid #ddd');
                                $('#useridWarning').html(
                                    '<span style="color:green">Available</span>');
                            }
                        }
                    });
                }
            });

            $('#customer_code').on('change', function() {
                let oldcustomerCode = $('#oldcustomer_code').val();
                let customerCode = $(this).val();

                if (oldcustomerCode == customerCode) {
                    $('#updateBtn').show();
                    $('#customer_code').css('border', '1px solid #ddd');
                    $('#customerCodeWarning').html('<span></span>');
                } else {
                    $.ajax({
                        type: 'get',
                        url: '<?php echo e(route('checkCustomerCode')); ?>',
                        data: {
                            customerCode: customerCode
                        },
                        success: function(data) {
                            if (data != true) {
                                $('#updateBtn').hide();
                                $('#customer_code').css('border', '1px solid red');
                                $('#customerCodeWarning').html(
                                    '<span style="color:red">Not Available</span>');
                            } else {
                                $('#updateBtn').show();
                                $('#customer_code').css('border', '1px solid #ddd');
                                $('#customerCodeWarning').html(
                                    '<span style="color:green">Available</span>');
                            }
                        }
                    });
                }
            });

            $('#cable_type').on('change', function() {
                let cat_type = $('#cat_type');
                let cat_length = $('#cat_length');
                cat_type.prop("required", false);
                cat_length.prop("required", false);
            });

            $('#cat_type').on('change', function() {
                let cat_length = $('#cat_length');
                cat_length.prop("required", true);
                let cable_type = $('#cable_type');
                cable_type.prop("required", false);
            });



            $('#from_cable').on('change', function() {
                var from_cable = $('#from_cable').val();
                var to_cable = $('#to_cable').val();
                calculateCableMeter(from_cable, to_cable);
            });

            $('#to_cable').on('change', function() {
                var from_cable = $('#from_cable').val();
                var to_cable = $('#to_cable').val();
                calculateCableMeter(from_cable, to_cable);
            });

            $('#from_cable2').on('keyup', function() {
                var from_cable2 = $('#from_cable2').val();
                var to_cable2 = $('#to_cable2').val();
                calculateCableMeter2(from_cable2, to_cable2);
            });

            $('#to_cable2').on('keyup', function() {
                var from_cable2 = $('#from_cable2').val();
                var to_cable2 = $('#to_cable2').val();
                calculateCableMeter2(from_cable2, to_cable2);
            });

            var difference1 = 0;
            var difference2 = 0;

            function calculateCableMeter($start, $end) {
                // $('#total_cable_meter').val(Math.abs($start - $end));
                difference1 = Math.abs($start - $end);
                $('#total_cable_meter').val(difference1 + difference2);
            }

            function calculateCableMeter2($start, $end) {
                difference2 = Math.abs($start - $end);
                $('#total_cable_meter').val(difference1 + difference2);
            }


            $('#pop_id').on('change', function() {
                let id = $(this).val();
                let billGenerateinfo = $(this).find(':selected').data('billgenerate');
                console.log(billGenerateinfo);


                if (billGenerateinfo == 'yes') {
                    $('#clientPaymentContainer').hide();
                } else {
                    $('#clientPaymentContainer').show();
                }

                $.ajax({
                    type: 'get',
                    url: '<?php echo e(route('getPackageForPop')); ?>',
                    data: {
                        id: id
                    },
                    success: function(data) {
                        $('#package_id option').remove();
                        $('#package_id').append(data);
                    }
                });


                $.ajax({
                    type: 'get',
                    url: '<?php echo e(route('getResellerArea')); ?>',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#area').html(result);
                    }
                });

                $.ajax({
                    type: 'get',
                    url: '<?php echo e(route('getBox')); ?>',
                    data: {
                        pop_id: $(this).val()
                    },
                    success: function(data) {
                        $('#box_id').html(
                            '<option selected value="">Select Box</option>' +
                            data
                        );

                    }
                })
            })

        });

        // for area select
        $('#area_select').on('change', function() {
            var area = $('#area_select').val();
            $('#area').val(area);
        });


        function formatMAC(e) {
            var r = /([a-f0-9]{2})([a-f0-9]{2})/i,
                str = e.target.value.replace(/[^a-f0-9]/ig, "");

            while (r.test(str)) {
                str = str.replace(r, '$1' + ':' + '$2');
            }

            e.target.value = str.slice(0, 17);
        };
    </script>
    <script>
        $('document').ready(function() {

            $('#division_id').change(function() {
                var id = $('#division_id').val();
                $.ajax({
                    url: '<?php echo e(route('fetchDistrict')); ?>',
                    type: 'get',
                    data: {
                        id: id
                    },
                    dataType: 'json',
                    success: function(data) {
                        $('#district_id').html(data);
                    }
                });
            });

            $('#district_id').change(function() {
                var id = $('#district_id').val();
                $.ajax({
                    url: '<?php echo e(route('fetchUpazila')); ?>',
                    type: 'get',
                    data: {
                        id: id
                    },
                    dataType: 'json',
                    success: function(data) {
                        $('#upazila_id').html(data);
                    }
                });
            });

            $('#upazila_id').change(function() {
                var id = $('#upazila_id').val();
                $.ajax({
                    url: '<?php echo e(route('fetchThana')); ?>',
                    type: 'get',
                    data: {
                        id: id
                    },
                    dataType: 'json',
                    success: function(data) {
                        $('#thana_id').html(data);
                    }
                });
            });
        });
    </script>

    <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(env('MIX_MAP_API_KEY')); ?>&libraries=maps,marker&v=beta"
        defer></script>
    <script type="module">
        $('document').ready(function() {
            $.ajax({
                url: '<?php echo e(route('boxes.index')); ?>',
                type: 'get',
                success: function(data) {
                    console.log(data);
                    $('#map_box').html(
                        `<option value="">Select Box</option>` +
                        data.map(item =>
                            `<option value="${item.id}" ${ <?php echo e($r->clientsinfo->map_box_id ? $r->clientsinfo->map_box_id : 'null'); ?> === item.id ? 'selected' : ''}>${item.id}.${item.name}</option>`
                        ).join(
                            '')
                    );
                }
            });

            let map;
            let boxMarkar;
            let clientMarkar;

            $('#map_box').on('change', async function() {
                const boxId = $(this).val();

                const box = await fetch(`<?php echo e(route('boxes.coordinates', '')); ?>/${boxId}`);
                const boxCordinate = await box.json();
                const latLong = JSON.parse(boxCordinate.coordinates);


                async function initMap() {
                    map = new google.maps.Map(document.getElementById('map'), {
                        center: latLong,
                        zoom: 17,
                        mapId: "select_location_client"
                    });

                    boxMarkar = new google.maps.Marker({
                        map,
                        position: latLong,
                        icon: "/images/box.png",
                    });

                    google.maps.event.addListener(map, 'click', function(event) {
                        placeMarker(event.latLng);
                    });

                    function placeMarker(location) {
                        if (clientMarkar) {
                            clientMarkar.setPosition(location);
                        } else {
                            clientMarkar = new google.maps.Marker({
                                position: location,
                                map: map
                            });
                        }
                    }
                    $("#mapModal").modal('show');
                }

                initMap();

            });

            $('#save-location-btn').on('click', function() {
                if (clientMarkar) {
                    console.log(clientMarkar)
                    const lat = clientMarkar.getPosition().lat();
                    const lng = clientMarkar.getPosition().lng();
                    $('#client_latitude').val(lat);
                    $('#client_longitude').val(lng);

                }

                $("#mapModal").modal('hide');
                map = null;
                boxMarkar = null;
                clientMarkar = null;
            });
        })
    </script>

    <script type="text/javascript">
        // Add image click handler
        $(document).ready(function() {
            // Add click handler to all images in the file_info div
            $('#file_info img').each(function() {
                var img = $(this);
                var infoDiv = img.closest('.form-group').find('.image-info');
                var imgSrc = img.attr('src');

                // Get file extension from src
                var extension = imgSrc.split('.').pop().toLowerCase();

                // Fetch the image file size and dimensions
                fetch(imgSrc)
                    .then(response => {
                        // Get file size from response headers
                        const size = response.headers.get('content-length');
                        let sizeText = '';
                        if (size) {
                            // Convert to MB if larger than 1MB, otherwise show in KB
                            if (size > 1024 * 1024) {
                                sizeText = (size / (1024 * 1024)).toFixed(2) + ' MB';
                            } else {
                                sizeText = (size / 1024).toFixed(2) + ' KB';
                            }
                        }

                        // Create a new image object to get the dimensions
                        var tempImg = new Image();
                        tempImg.onload = function() {
                            var width = this.width;
                            var height = this.height;
                            // Combine size, dimensions and file type
                            var fullText = sizeText + ' (' + width + ' x ' + height + ' px) - ' +
                                extension.toUpperCase();
                            infoDiv.text(fullText);
                        }
                        tempImg.src = imgSrc;
                    })
                    .catch(error => {
                        console.error('Error fetching image:', error);
                    });

                // Add click handler for modal
                img.css('cursor', 'pointer').click(function() {
                    var imgSrc = $(this).attr('src');
                    $('#modalImage').attr('src', imgSrc);
                    $('#imageModal').modal('show');
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/rk/radius-circle/resources/views/clients/edit.blade.php ENDPATH**/ ?>