<?php

namespace App\Models;

use App\Models\User;
use App\Models\Client;
use App\Models\Clientsinfo;
use Facade\Ignition\Support\Packagist\Package;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Billpayment extends Model
{
    use HasFactory;
    protected $table ='bill_payments';
    // protected $fillable = [
    //     'description',
    //     'paid_amount',
    //     'discount_amount',
    //     'child_id',
    //     'user_id',
    //     'collected_by',

    // ];
    protected $guarded = ['id'];

    public function user()
    {
        return $this->belongsTo(User::class,'user_id','id');
    }

    public function clientsinfo(){
        return $this->belongsTo(Clientsinfo::class,'client_id','client_id');
    }
    public function clients(){
        return $this->belongsTo(Client::class,'client_id','id')->withTrashed();
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class,'collected_by','id');
    }

    public function income()
    {
        return $this->belongsTo(Income::class,'income_id','id');
    }

    public function package()
    {
        // return $this->belongsTo(Package::class,'')
    }

    
}
