<?php $__env->startSection('body'); ?>
    <?php echo $__env->make('Customer.left-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style>
        .custom-select-wrapper {
            position: relative;
            width: 100%;
        }

        .custom-select-trigger {
            background: white;
            border: 2px solid #e0e0e0;
            border-radius: 12px;
            padding: 16px 20px;
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.3s ease;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .custom-select-trigger:hover {
            border-color: #667eea;
            box-shadow: 0 6px 12px rgba(102, 126, 234, 0.2);
        }

        .custom-select-trigger.active {
            border-color: #667eea;
            border-radius: 12px 12px 0 0;
        }

        .select-trigger-text {
            color: #666;
            font-size: 15px;
        }

        .select-trigger-text.selected {
            color: #333;
            font-weight: 500;
        }

        .select-arrow {
            width: 0;
            height: 0;
            border-left: 6px solid transparent;
            border-right: 6px solid transparent;
            border-top: 6px solid #666;
            transition: transform 0.3s ease;
        }

        .custom-select-trigger.active .select-arrow {
            transform: rotate(180deg);
        }

        .custom-select-options {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            background: white;
            border: 2px solid #667eea;
            border-top: none;
            border-radius: 0 0 12px 12px;
            max-height: 0;
            overflow: hidden;
            opacity: 0;
            transition: all 0.3s ease;
            z-index: 1000;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.15);
        }

        .custom-select-options.active {
            max-height: 400px;
            opacity: 1;
            overflow-y: auto;
        }

        .custom-select-options::-webkit-scrollbar {
            width: 8px;
        }

        .custom-select-options::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 0 0 12px 0;
        }

        .custom-select-options::-webkit-scrollbar-thumb {
            background: #667eea;
            border-radius: 4px;
        }

        .custom-option {
            padding: 16px 20px;
            cursor: pointer;
            transition: all 0.2s ease;
            border-bottom: 1px solid #f0f0f0;
        }

        .custom-option:last-child {
            border-bottom: none;
        }

        .custom-option:hover {
            background: linear-gradient(90deg, #f8f9ff 0%, #fff 100%);
        }

        .option-name {
            font-weight: 600;
            color: #333;
            font-size: 16px;
            margin-bottom: 6px;
        }

        .option-details {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 20px;
        }

        .option-rate {
            color: #667eea;
            font-weight: 500;
            font-size: 14px;
        }

        .option-cost {
            color: #28a745;
            font-weight: 600;
            font-size: 14px;
            background: #e8f5e9;
            padding: 4px 12px;
            border-radius: 20px;
        }

        .option-cost.zero {
            color: #666;
            background: #f5f5f5;
        }

        #change_package_btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 14px 32px;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            width: 100%;
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
            position: relative;
            overflow: hidden;
        }

        #change_package_btn:before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transition: left 0.5s;
        }

        #change_package_btn:hover:before {
            left: 100%;
        }

        #change_package_btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
        }

        #change_package_btn:active {
            transform: translateY(0);
            box-shadow: 0 3px 8px rgba(102, 126, 234, 0.3);
        }

        #change_package_btn:disabled {
            background: #ccc;
            cursor: not-allowed;
            transform: none;
            box-shadow: none;
        }
    </style>


    <main id="main" class="main">
        <div class="pagetitle">
            <h1>Dashboard</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('customerDashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Dashboard</li>
                </ol>
            </nav>
        </div><!-- End Page Title -->

        <section class="section dashboard">
            <div class="row">

                <!-- Left side columns -->
                <div class="col-lg-12">
                    <div class="row">

                        <!-- Sales Card -->
                        <div class="col-12 col-md-6 col-lg-3 mb-3">
                            <div class="card info-card sales-card">
                                <div class="card-body">
                                    <h5 class="card-title">Balance <span>| Inquiry</span></h5>
                                    <div class="d-flex align-items-center">
                                        <div
                                            class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-bank2"></i>
                                        </div>
                                        <div class="ps-3">
                                            <h6>
                                                <?php if(isset($details['account']->dueAmount) && $details['account']->dueAmount < 1): ?>
                                                    <?php echo e(abs($details['account']->dueAmount)); ?>

                                                <?php else: ?>
                                                    0
                                                <?php endif; ?>
                                            </h6>
                                            <span class="text-success small pt-1 fw-bold">Due</span>
                                            <span class="text-muted small pt-2 ps-1">
                                                <?php if(isset($details['account']->dueAmount) && $details['account']->dueAmount > 0): ?>
                                                    <span class="text-red-600 font-bold">
                                                        <?php echo e(abs($details['account']->dueAmount)); ?>

                                                    </span>
                                                <?php else: ?>
                                                    0
                                                <?php endif; ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- End Sales Card -->

                        <!-- Revenue Card -->
                        <div class="col-12 col-md-6 col-lg-3 mb-3">
                            <div class="card info-card revenue-card">
                                <div class="card-body">
                                    <h5 class="card-title">Packages |
                                        <?php if(checkSettings('package-name-show-in-customer-dashboard') == 'enable'): ?>
                                            <span> <?php echo e($details['package']->package_name); ?></span>
                                        <?php endif; ?>
                                    </h5>

                                    <div class="d-flex align-items-center">
                                        <div
                                            class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-box-seam"></i>
                                        </div>
                                        <div class="ps-3">
                                            <?php if(checkSettings('ResellerClientOnlineRecharge') == 'enable' && $details['userinfo']->pop->bill_generate == 'no'): ?>
                                                <?php if(checkSettings('setClientPaymentAmountToClient') == 'enable' && $details['userinfo']->client_payment_amount > 0): ?>
                                                    <h6><?php echo e($details['userinfo']->client_payment_amount); ?>TK</h6>
                                                <?php else: ?>
                                                    <h6><?php echo e($details['package']->client_payment_amount); ?>TK</h6>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <h6><?php echo e($details['package']->package_rate); ?>TK</h6>
                                            <?php endif; ?>
                                            <span class="text-success small pt-1 fw-bold">Expire:</span> <span
                                                class="text-muted small pt-2 ps-1"><?php echo e(date('d-M-Y', strtotime($details['userinfo']->expire_date))); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- End Revenue Card -->

                        <!-- Customers Card -->
                        <div class="col-12 col-md-6 col-lg-3 mb-3">
                            <div onclick="location.href='<?php echo e(route('customer-payment')); ?>'"
                                class="card info-card customers-card">
                                <div class="card-body">
                                    <h5 class="card-title">Recharge <span>| Account</span></h5>
                                    <div class="d-flex align-items-center">
                                        <div
                                            class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-currency-exchange"></i>
                                        </div>
                                        <div class="ps-3">
                                            <h6><a href="<?php echo e(route('customer-payment')); ?>">Pay Now</a></h6>
                                            <span><a href="<?php echo e(route('customer-payment')); ?>"
                                                    class="text-danger small pt-1 fw-bold">Click Pay Now</a></span>
                                            <span class="text-muted small pt-2 ps-1">for Recharge</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <!-- Customers Card -->
                        <div class="col-12 col-md-6 col-lg-3 mb-3">
                            <div onclick="location.href='<?php echo e(route('customer-payment-history')); ?>'"
                                class="card info-card customers-card">
                                <div class="card-body">
                                    <h5 class="card-title">Payment History</h5>
                                    <div class="d-flex align-items-center">
                                        <div
                                            class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-table"></i>
                                        </div>
                                        <div class="ps-3">
                                            <h6><a href="<?php echo e(route('customer-payment-history')); ?>">Show History</a></h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>





                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="row">

                        <!-- Sales Card -->
                        <div class="col-lg-4 col-md-6 mb-3">
                            <div onclick="location.href='<?php echo e(route('customerTokenList')); ?>'"
                                class="card info-card sales-card" style="cursor: pointer;">
                                <div class="card-body">
                                    <h5 class="card-title"><a href="<?php echo e(route('customerTokenList')); ?>">Token <span>|
                                                List</span></a></h5>
                                    <div class="d-flex align-items-center">
                                        <div
                                            class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-card-checklist"></i>
                                        </div>
                                        <div class="ps-3">
                                            <h6><?php echo e($tokenListCount->count()); ?></h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- End Sales Card -->

                        <!-- Revenue Card -->
                        <div class="col-lg-4 col-md-6 mb-3">
                            <div onclick="location.href='<?php echo e(route('pendingTokenList')); ?>'"
                                class="card info-card customers-card" style="cursor: pointer;">
                                <div class="card-body">
                                    <h5 class="card-title"><a href="<?php echo e(route('pendingTokenList')); ?>">Pending <span>|
                                                Token</span></a></h5>
                                    <div class="d-flex align-items-center">
                                        <div
                                            class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-hourglass-split"></i>
                                        </div>
                                        <div class="ps-3">
                                            <h6><?php echo e($pendingTokenCount->count()); ?></h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- End Revenue Card -->

                        <!-- Customers Card -->
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div onclick="location.href='<?php echo e(route('customer-token.index')); ?>'"
                                class="card info-card sales-card" style="cursor: pointer;">
                                <div class="card-body">
                                    <h5 class="card-title"><a href="<?php echo e(route('customer-token.index')); ?>">Create <span>|
                                                Token</span></a></h5>
                                    <div class="d-flex align-items-center">
                                        <div
                                            class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-bag-plus-fill"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4 <?php if(!$re_active_btn_condition): ?> d-none <?php endif; ?>">
                            <div onclick="location.href='<?php echo e(route('reactive-from-customer')); ?>'"
                                class="card info-card sales-card" style="cursor: pointer;">
                                <div class="card-body">
                                    <h5 class="card-title"><a
                                            href="<?php echo e(route('reactive-from-customer')); ?>">Reactive</span></a></h5>
                                    <div class="d-flex align-items-center">
                                        <div
                                            class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-box-arrow-in-up"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 mb-4 <?php if(!$changePackagePermission): ?> d-none <?php endif; ?>">
                            <div class="card info-card sales-card">
                                <div class="card-body">
                                    <h5 class="card-title mb-0">Change Package</h5>
                                    <span class="text-danger">
                                        Note: After changing the package, refund is not possible.
                                    </span>

                                    <div class="d-flex align-items-center gap-3 mt-3">
                                        <div class="flex-grow-1">
                                            <!-- Hidden original select for form submission -->
                                            <select name="new_package" id="new_package" style="display: none;">
                                                <option value="">Select a package</option>
                                                <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php
                                                        $cost = 0;
                                                        if ($days_left_to_expire > 0) {
                                                            if ($details['userinfo']->pop->subreseller == 'yes') {
                                                                if (
                                                                    $details['package']->package_rate < $package->rate
                                                                ) {
                                                                    $cost =
                                                                        ($package->rate / 30) * $days_left_to_expire;
                                                                }
                                                            } else {
                                                                if (
                                                                    $details['package']->package_rate <
                                                                    $package->package_rate
                                                                ) {
                                                                    $cost =
                                                                        ($package->package_rate / 30) *
                                                                        $days_left_to_expire;
                                                                }
                                                            }
                                                        }
                                                    ?>
                                                    <option value="<?php echo e($package->id); ?>" data-cost="<?php echo e($cost); ?>"
                                                        data-rate="<?php echo e($package->package_rate); ?>">
                                                        <?php echo e($package->package_name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>

                                            <!-- Custom Select Dropdown -->
                                            <div class="custom-select-wrapper">
                                                <div class="custom-select-trigger">
                                                    <span class="select-trigger-text">Select a package</span>
                                                    <div class="select-arrow"></div>
                                                </div>
                                                <div class="custom-select-options">
                                                    <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            $cost = 0;
                                                            if ($days_left_to_expire > 0) {
                                                                if ($details['userinfo']->pop->subreseller == 'yes') {
                                                                    if (
                                                                        $details['package']->package_rate <
                                                                        $package->rate
                                                                    ) {
                                                                        $cost =
                                                                            ($package->rate / 30) *
                                                                            $days_left_to_expire;
                                                                    }
                                                                } else {
                                                                    if (
                                                                        $details['package']->package_rate <
                                                                        $package->package_rate
                                                                    ) {
                                                                        $cost =
                                                                            ($package->package_rate / 30) *
                                                                            $days_left_to_expire;
                                                                    }
                                                                }
                                                            }
                                                            $costClass = $cost == 0 ? 'zero' : '';
                                                        ?>
                                                        <div class="custom-option" data-value="<?php echo e($package->id); ?>">
                                                            <div class="option-name"><?php echo e($package->package_name); ?></div>
                                                            <div class="option-details">
                                                                <span class="option-rate">Rate:
                                                                    <?php echo e(number_format($package->package_rate)); ?> TK</span>
                                                                <span class="option-cost <?php echo e($costClass); ?>">Cost:
                                                                    <?php echo e(number_format($cost)); ?> TK</span>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mt-3">
                                        <button id="change_package_btn" type="button">
                                            Confirm Change
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <!-- End Customers Card -->
                        <?php if(checkSettings('livespeed-client-portal') == 'enable'): ?>
                            <?php echo $__env->make('Customer.customerLiveSpeed', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="row">

                        <!-- Sales Card -->
                        <div class="col-xxl-4 col-md-4 d-none">
                            <div class="card info-card sales-card">

                                <div class="card-body">
                                    <h5 class="card-title">New Customer <span>| Request</h5>

                                    <div class="d-flex align-items-center">
                                        <div
                                            class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-person-plus"></i>
                                        </div>

                                    </div>
                                </div>

                            </div>
                        </div><!-- End Sales Card -->

                        <!-- Revenue Card -->
                        <div class="col-xxl-4 col-md-4 d-none">
                            <div class="card info-card revenue-card">
                                <div class="card-body">
                                    <h5 class="card-title">Notice Board <span>| Latest</span></h5>

                                    <div class="d-flex align-items-center">
                                        <div
                                            class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-bell-fill"></i>
                                        </div>

                                    </div>
                                </div>

                            </div>
                        </div><!-- End Revenue Card -->

                        <!-- Customers Card -->
                        <div class="col-xxl-4 col-md-4 d-none">

                            <div class="card info-card customers-card">

                                <div class="card-body">
                                    <h5 class="card-title">Complaints and Help Center</h5>

                                    <div class="d-flex align-items-center">
                                        <div
                                            class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-question-diamond-fill"></i>
                                        </div>

                                    </div>

                                </div>
                            </div>

                        </div><!-- End Customers Card -->


                    </div>
                </div>
            </div>

        </section>

    </main><!-- End #main -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://js.pusher.com/7.0/pusher.min.js"></script>
    <link rel="stylesheet" href="<?php echo e(asset('/')); ?>plugins/select2/css/select2.min.css">
    <script src="<?php echo e(asset('/')); ?>plugins/select2/js/select2.full.min.js"></script>

    <script>
        $(document).ready(function() {
            const $select = $('#new_package');
            const $customTrigger = $('.custom-select-trigger');
            const $customOptions = $('.custom-select-options');
            const $triggerText = $('.select-trigger-text');

            // Toggle dropdown
            $customTrigger.on('click', function(e) {
                e.stopPropagation();
                $(this).toggleClass('active');
                $customOptions.toggleClass('active');
            });

            // Select option - FIXED!
            $('.custom-option').on('click', function(e) {
                e.stopPropagation();

                const value = $(this).data('value');
                const text = $(this).find('.option-name').text();

                // Update hidden select
                $select.val(value).trigger('change');

                // Update trigger text
                $triggerText.text(text).addClass('selected');

                // Close dropdown
                $customTrigger.removeClass('active');
                $customOptions.removeClass('active');

                // Remove active state from all options
                $('.custom-option').css('background', '');

                // Highlight selected option
                $(this).css('background', 'linear-gradient(90deg, #e8f0ff 0%, #fff 100%)');
            });

            // Close dropdown when clicking outside
            $(document).on('click', function() {
                $customTrigger.removeClass('active');
                $customOptions.removeClass('active');
            });

            // Prevent closing when clicking inside options
            $customOptions.on('click', function(e) {
                e.stopPropagation();
            });

            // Confirm button action
            $('#change_package_btn').click(function() {
                var selectedPackageId = $('#new_package').val();
                if (!selectedPackageId) {
                    toastr.error('Please select a package to change.');
                    return;
                }

                var cost = $('#new_package option:selected').data('cost');

                var clientBalance =
                    <?php echo e(isset($details['account']->dueAmount) ? $details['account']->dueAmount : 0); ?>;
                var client_id = <?php echo e($details['userinfo']->id); ?>;

                let balance = 0;
                if (clientBalance <= 0) {
                    balance = Math.abs(clientBalance);
                } else {
                    balance = clientBalance;
                }

                if (cost > balance) {
                    toastr.error('Insufficient balance to change the package. Required cost is ' + cost + ' TK.');
                    return;
                }


                if (confirm('Are you sure you want to change the package? The cost will be ' + cost +
                        ' TK.')) {
                    // ajax call to change package
                    $.ajax({
                        type: 'POST',
                        url: '<?php echo e(route('customer-change-package')); ?>',
                        data: {
                            new_package: selectedPackageId,
                            client_id: client_id,
                            _token: '<?php echo e(csrf_token()); ?>'
                        },
                        success: function(response) {
                            toastr.success('Package changed successfully.');
                            location.reload();
                        },
                        error: function(xhr, status, error) {
                            console.log(error,status,xhr);

                            toastr.error(
                                'An error occurred while changing the package. Please try again.'
                            );
                        }
                    });
                }
            });
        });
    </script>



    <script>
        function create_UUID() {
            var dt = new Date().getTime();
            var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
                var r = (dt + Math.random() * 16) % 16 | 0;
                dt = Math.floor(dt / 16);
                return (c == 'x' ? r : (r & 0x3 | 0x8)).toString(16);
            });
            return uuid;
        }


        const data = {
            labels: [],
            datasets: [{
                label: 'Downloads',
                backgroundColor: '#333C83',
                borderColor: '#333C83',
                data: [],
                tension: 0.3,


            }, {
                label: 'Uploads',
                backgroundColor: 'rgb(255, 99, 132)',
                borderColor: 'rgb(255, 99, 132)',
                data: [],
                tension: 0.3,


            }]
        };


        const config = {
            type: 'line',
            data: data,
            options: {
                scales: {
                    y: {
                        ticks: {
                            callback: function(value, index, ticks) {
                                return value > 1 ? value + 'Mb' : (value * 1024) + "Kb";
                            }
                        }
                    }
                },
                plugins: {
                    title: {
                        display: true,
                        text: 'Real-Time Speed',
                        padding: {
                            top: 10,
                            bottom: 10
                        },
                        font: {
                            size: 15,

                        }
                    },
                    legend: {
                        labels: {
                            // This more specific font property overrides the global property
                            font: {
                                size: 12
                            }
                        }
                    }
                }
            }
        };

        const myChart = new Chart(
            document.getElementById('myChart'),
            config
        );

        let usageData = [1, 1];
        if (!('<?php echo e($error); ?>'.length > 0)) {
            usageData = [
                (<?php echo e(($bandwidthUsage ? $bandwidthUsage['tx-byte'] : 1) / 1048576); ?>).toFixed(3),
                (<?php echo e(($bandwidthUsage ? $bandwidthUsage['rx-byte'] : 1) / 1048576); ?>).toFixed(3),
            ]
        }

        const pieChartData = {
            labels: [
                'Downloads',
                'Uploads',
            ],
            datasets: [{
                label: 'My First Dataset',
                data: usageData,
                backgroundColor: [
                    '#333C83',
                    'rgb(255, 99, 132)',
                ],
                hoverOffset: 4
            }]

        };

        const pieChartConfig = {
            type: 'doughnut',
            data: pieChartData,
        }

        const pieChart = new Chart(
            document.getElementById('pieChart'),
            pieChartConfig
        );


        $('#speedshow').click(function() {
            console.log('clicked');
            $('#speedshow').hide();
            const uuid = create_UUID();


            const currentTime = () => {
                const today = new Date();
                const time = today.getHours() + ":" + today.getMinutes() + ":" + today.getSeconds();
                return time;
            }

            const addData = (chart, download, upload) => {
                const time = currentTime();

                chart.data.datasets[0].label = download > 1 ? `Download ${download.toFixed(3)} Mbps` :
                    `Download ${(download *1024).toFixed(3)} Kbps`
                chart.data.datasets[1].label = upload > 1 ? `Upload ${upload.toFixed(3)} Mbps` :
                    `Upload ${(upload *1024).toFixed(3)} Kbps`

                chart.data.labels.push(time)
                chart.data.datasets[0].data.push(download);
                chart.data.datasets[1].data.push(upload)
                chart.update();

            }

            function removeData(chart) {
                chart.data.labels.shift();
                chart.data.datasets.forEach((dataset) => {
                    dataset.data.shift();
                });
                chart.update();
            }
            const pusher = new Pusher('<?php echo e(config('broadcasting.connections.pusher.key')); ?>', {
                cluster: '<?php echo e(config('broadcasting.connections.pusher.options.cluster')); ?>'
            });
            const user_id = $('#user_Id').val();
            const admin_user_id = $('#admin_user_Id').val();

            const channel = pusher.subscribe(uuid);

            channel.bind('my-event', function(data) {
                const speed = JSON.parse(JSON.parse(JSON.stringify(data)).message)[0];
                const upload = speed["rx-bits-per-second"] / 1048576;
                const download = speed["tx-bits-per-second"] / 1048576;

                if (myChart.data.datasets[0].data.length > 15) {
                    removeData(myChart);
                }
                addData(myChart, download, upload)

            });


            $(document).ready(function() {
                // select2 for package


                const user_id = $('#user_Id').val();
                const admin_user_id = $('#admin_user_Id').val();
                $.ajax({
                    type: 'GET',
                    url: '<?php echo e(route('getClientSpeed')); ?>',
                    data: {
                        id: user_id,
                        uuid: uuid,

                    },
                    success: function(data) {
                        $('#speedshow').show();

                    },
                    error: function(request, error) {
                        toastr.error(request.responseText);
                        $('#speedshow').show();
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Customer.customer-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/rk/radius-circle/resources/views/Customer/customer-dashboard.blade.php ENDPATH**/ ?>