<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dashboard-billing-info')): ?>
    <?php if(checkSettings('reseller_bill_collection') == 'enable'): ?>
        <section class="bill-collection-area bg-white pt-2  mt-2 mb-2 pb-2">
            <h4 class="text-center my-2">Manager (only other) Bill Collection
                <?php echo e(date('M')); ?> <?php echo e(date('Y')); ?></h4>
            <table class="table table-hover table-responsive-lg">
                <thead>
                    <tr>
                        <th scope="col" class="h6">Manager Name</th>
                        <th scope="col" class="h6 text-right">Approximate Monthly Bill</th>
                        <th scope="col" class="h6 text-right">Previous Month Bill Collection</th>
                        <th scope="col" class="h6 text-right">This Month Bill Collection</th>
                        <th scope="col" class="h6 text-right">Collection(%)</th>
                        <th scope="col" class="h6 text-right">This Month Due</th>
                    </tr>
                </thead>
                <tbody>
                    <?php

                        $this_month_bill = 0;
                        $previous_month_collection = 0;
                        $this_month_collection = 0;
                    ?>

                    <?php $__currentLoopData = $resellerWiseOtherReport; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $bill = 0;

                            foreach ($item as $r) {
                                $bill += $r->total_client * $r->package_rate;
                            }
                        ?>
                        <tr>
                            <td class="h6">
                                <?php echo e($item->first()->name); ?>

                            </td>
                            <td class="text-right"><?php echo e($bill); ?></td>
                            <td class="text-right"><?php echo e($item->previous_monthly_bill_collection); ?></td>
                            <td class="text-right"><?php echo e($item->monthly_bill_collection); ?></td>
                            <td class="text-right">
                                <?php if($bill !=0 && $item->monthly_bill_collection != 0): ?>
                                    <?php echo e(round(($item->monthly_bill_collection * 100) / $bill, 2)); ?> %
                                <?php endif; ?>
                            </td>
                            <td class="text-right"><?php echo e($bill - $item->monthly_bill_collection); ?></td>
                        </tr>

                        <?php
                            $this_month_bill += $bill;
                            $previous_month_collection += $item->previous_monthly_bill_collection;
                            $this_month_collection += $item->monthly_bill_collection;
                        ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <tr class="bg-gray">
                        <td class="h6">Total</td>
                        <td class="h6 text-right"><?php echo e($this_month_bill); ?></td>
                        <td class="h6 text-right"><?php echo e($previous_month_collection); ?></td>
                        <td class="h6 text-right"><?php echo e($this_month_collection); ?></td>
                        <td class="h6 text-right">
                            <?php if($this_month_bill != 0): ?>
                                <?php echo e(round(($this_month_collection * 100) / $this_month_bill, 2)); ?> %
                            <?php else: ?>
                                0 %
                            <?php endif; ?>
                        </td>
                        <td class="h6 text-right"><?php echo e($this_month_bill - $this_month_collection); ?></td>
                    </tr>
                </tbody>
            </table>
        </section>
    <?php endif; ?>
<?php endif; ?>
<?php /**PATH /var/www/html/rk/radius-circle/resources/views/dashboard/new/resellerRchargeReportNew.blade.php ENDPATH**/ ?>