@extends('layout.app')




@section('content')
    <div class="card">
        <div class="card-body">

            <form class=" form-type-material" action="{{ route('company-settings.store') }}" method="POST"
                enctype="multipart/form-data">
                @csrf


                <div class="card  card-tabs">
                    <div class="card-header p-0 pt-1">
                        <ul class="nav nav-tabs" id="custom-tabs-one-tab" role="tablist">

                            <li class="nav-item">
                                <a class="nav-link active" id="custom-tabs-one-auto-wellcome-sms-tab" data-toggle="pill"
                                    href="#custom-tabs-one-auto-wellcome-sms" role="tab"
                                    aria-controls="custom-tabs-one-auto-wellcome-sms" aria-selected="true">Site Setting</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" id="custom-tabs-one-bill-payment-tab" data-toggle="pill"
                                    href="#custom-tabs-one-bill-payment" role="tab"
                                    aria-controls="custom-tabs-one-bill-payment" aria-selected="false">Payment Button</a>
                            </li>
                            @if (auth()->user()->id == 1 || auth()->user()->email == 'admin@billingfix.xyz')
                                <li class="nav-item">
                                    <a class="nav-link" id="yetfix-notice-tab" data-toggle="pill" href="#yetfix-notice"
                                        role="tab" aria-controls="yetfix-notice" aria-selected="false">Yetfix Notice</a>
                                </li>
                            @endif

                        </ul>
                    </div>
                    <div class="card-body">
                        <div class="tab-content" id="custom-tabs-one-tabContent">
                            <div class="tab-pane fade show active" id="custom-tabs-one-auto-wellcome-sms" role="tabpanel"
                                aria-labelledby="custom-tabs-one-auto-wellcome-sms-tab">

                                <div class="container col-md-12">
                                    <div class="container-fluid">
                                        <div class="col-sm-12  col-md-12">

                                            <div class="container-fluid">
                                                <div class="row">
                                                    <div class="col-sm-12">
                                                        @php
                                                            $telegram = json_decode($data->telegram);
                                                            $telegram_support = json_decode(
                                                                $data->telegram_for_support,
                                                            );

                                                        @endphp


                                                        <div class="card-body">


                                                            <div class="site-settings">



                                                                <div class="w-100 border p-3">
                                                                    <label for="invoice_terms" class="sr-only">Company
                                                                        Logo</label>

                                                                    @if ($data->img_url)
                                                                        <img width="100" height="100"
                                                                            src="{{ asset('storage/company/' . $data->img_url) }}"
                                                                            alt="No Image" class="rounded-circle"
                                                                            style="overflow: hidden">
                                                                    @else
                                                                        <h3 class="lead">Logo Haven't Set</h3>
                                                                    @endif


                                                                    <div class="flex-grow border p-1 mt-3 rounded ">
                                                                        <h5> Change Logo </h5>
                                                                        <div
                                                                            class="d-flex flex-column flex-sm-row gap-y gap-items-2 mt-16">

                                                                            <div class="file-group file-group-inline">
                                                                                <input type="file" name="img_url"
                                                                                    accept="image/*">

                                                                            </div>


                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                <div class="w-100 border p-3 position-relative text-center">
                                                                    <h1 class="sr-only">Company
                                                                        Landing Image</h1>

                                                                    @if ($data->landing_image)
                                                                        <img width="100" height="100"
                                                                            src="{{ asset('storage/company/' . $data->landing_image) }}"
                                                                            alt="No Image" class="rounded-circle"
                                                                            style="overflow: hidden">
                                                                    @else
                                                                        <h3 class="lead  text-left">Landing Image Haven't
                                                                            Set</h3>
                                                                    @endif


                                                                    <div class="flex-grow border p-1 mt-3 rounded ">
                                                                        <h5> Change Landing Image </h5>
                                                                        <div
                                                                            class="d-flex flex-column flex-sm-row gap-y gap-items-2 mt-16">

                                                                            <div class="file-group file-group-inline">
                                                                                <input type="file" name="landing_image"
                                                                                    accept="image/*">

                                                                            </div>


                                                                        </div>
                                                                    </div>

                                                                    @error('landing_image')
                                                                        <div class="alert alert-danger position-absolute w-100"
                                                                            style="top: 1px; right:1px; ">{{ $message }}
                                                                        </div>
                                                                    @enderror

                                                                    <button type="button" class="btn btn-info mt-3"
                                                                        onclick="onlinePaymentUrl()">Online Payment
                                                                        Url</button>

                                                                </div>


                                                                @if (auth()->user()->id == 1 || auth()->user()->email == 'admin@billingfix.xyz')
                                                                    <div class="w-100 border p-3">
                                                                        <label for="invoice_terms"
                                                                            class="sr-only">Qrcode</label>


                                                                        @if ($data->qrcode)
                                                                            <img width="100" height="100"
                                                                                src="{{ asset('storage/company/' . $data->qrcode) }}"
                                                                                alt="No Image" class="rounded-circle">
                                                                        @else
                                                                            <h3 class="lead">QRCODE Haven't Set</h3>
                                                                        @endif

                                                                        <div class="flex-grow border p-1 mt-3 rounded ">
                                                                            <h5> Change QR Code</h5>
                                                                            <div
                                                                                class="d-flex flex-column flex-sm-row gap-y gap-items-2 mt-16">
                                                                                <div class="file-group file-group-inline">
                                                                                    <input type="file" name="qrcode"
                                                                                        accept="image/*">

                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                @endif
                                                                @if (auth()->user()->id == 1 || auth()->user()->email == 'admin@billingfix.xyz')
                                                                    <div class="w-100 border p-3">
                                                                        <label for="invoice_terms"
                                                                            class="sr-only">Signature</label>

                                                                        @if ($data->signature)
                                                                            <img width="100" height="100"
                                                                                src="{{ asset('storage/company/' . $data->signature) }}"
                                                                                alt="No Image" class="rounded-circle">
                                                                        @else
                                                                            <h3 class="lead">Signature Haven't Set</h3>
                                                                        @endif

                                                                        <div class="flex-grow border p-1 mt-3 rounded ">
                                                                            <h5> Change Signature</h5>
                                                                            <div
                                                                                class="d-flex flex-column flex-sm-row gap-y gap-items-2 mt-16">
                                                                                <div class="file-group file-group-inline">
                                                                                    <input type="file" name="signature"
                                                                                        accept="image/*">

                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                @endif



                                                                @if (checkAPI())
                                                                    <div class="w-100 border p-3">
                                                                        <div class="d-flex flex-column justify-content-between "
                                                                            style="height: 100% !important;">

                                                                            <button id="sync-mikrotik-ip-to-software"
                                                                                class="btn border">Sync MK clients
                                                                                Ip to Software</button>


                                                                            <button id="sync-mikrotik-mac-to-software"
                                                                                class="btn border">Sync MK clients
                                                                                mac to Software</button>

                                                                            <button id="sync-online-client-mac-to-software"
                                                                                class="btn border">Sync Online clients MK
                                                                                mac to Software</button>

                                                                            <button id="client-online-ip-add-to-static-ip"
                                                                                class="btn border">Online Client Ip Add
                                                                                To
                                                                                Static Ip</button>
                                                                        </div>
                                                                    </div>
                                                                @endif

                                                                <div class="w-100 border p-3">
                                                                    @if (auth()->user()->id == 1 || checkSettings('mikrotik-connection-type-show') == 'enalbe')
                                                                        <div class="form-group do-float">
                                                                            <label>Mikrotik Conection Type</label>
                                                                            <h3
                                                                                class="lead text-uppercase text-danger font-weight-bold text-center border">
                                                                                {{ $data->mikrotik_conection_type }}</h3>


                                                                            <div class="flex-grow border p-2 mt-3 rounded "
                                                                                style="bottom: 0; left:8px; right:8px;">
                                                                                <h5 class="h5"> Change </h5>
                                                                                <select name="mikrotik_conection_type"
                                                                                    id="mikrotik_conection_type"
                                                                                    class="form-control">
                                                                                    <option value="radius"
                                                                                        @if ($data->mikrotik_conection_type == 'radius') selected @endif>
                                                                                        Radius
                                                                                    </option>
                                                                                    <option value="api"
                                                                                        @if ($data->mikrotik_conection_type == 'api') selected @endif>
                                                                                        Api
                                                                                    </option>
                                                                                </select>
                                                                            </div>

                                                                        </div>
                                                                    @endif
                                                                </div>

                                                                <div class="w-100 border p-3">
                                                                    @if (auth()->user()->id == 1 || checkSettings('mikrotik-connection-type-show') == 'enalbe')
                                                                        <div class="form-group do-float">
                                                                            <label>Show online off line in top</label>
                                                                            <h3
                                                                                class="lead text-uppercase text-danger font-weight-bold text-center border">
                                                                                {{ $data->online_offline_topbar }}</h3>


                                                                            <div class="flex-grow border p-2 mt-3 rounded  "
                                                                                style="bottom: 0; left:8px; right:8px;">
                                                                                <h5 class="h5"> Change</h5>
                                                                                <select name="online_offline_topbar"
                                                                                    id="online_offline_topbar"
                                                                                    class="form-control">
                                                                                    <option value="Yes"
                                                                                        @if ($data->online_offline_topbar == 'Yes') selected @endif>
                                                                                        Yes
                                                                                    </option>
                                                                                    <option value="No"
                                                                                        @if ($data->online_offline_topbar == 'No') selected @endif>
                                                                                        No
                                                                                    </option>
                                                                                </select>
                                                                            </div>

                                                                        </div>
                                                                    @else
                                                                        <div style="display:none;">
                                                                            <select name="online_offline_topbar"
                                                                                class="form-control">
                                                                                <option value="Yes"
                                                                                    {{ $data->online_offline_topbar == 'Yes' ? 'selected' : '' }}>
                                                                                    Yes</option>
                                                                                <option value="No"
                                                                                    {{ $data->online_offline_topbar == 'No' ? 'selected' : '' }}>
                                                                                    No</option>
                                                                            </select>
                                                                        </div>
                                                                    @endif
                                                                </div>


                                                                <div class="w-100 border p-3">
                                                                    <div class=" w-100 rounded p-2">
                                                                        <label>Expire Time</label>


                                                                        <div class="row">
                                                                            <div class="col-md-4">
                                                                                <label><input type="number"
                                                                                        max="23" min="0"
                                                                                        name="expire_hour"
                                                                                        class="form-control"
                                                                                        value="{{ $expire_time[0] }}"
                                                                                        placeholder="hour">Hour</label>
                                                                            </div>
                                                                            <div class="col-md-4">
                                                                                <label><input type="number"
                                                                                        max="59" min="0"
                                                                                        name="expire_minute"
                                                                                        class="form-control"
                                                                                        value="{{ $expire_time[1] }}"
                                                                                        placeholder="minute">Minute</label>
                                                                            </div>
                                                                            <div class="col-md-4">
                                                                                {{ $expire_time[0] }}:{{ $expire_time[1] }}
                                                                                :{{ $expire_time[2] }}
                                                                            </div>
                                                                        </div>

                                                                    </div>

                                                                    <div class="">
                                                                        <label for="">Expire Sms Send Time</label>
                                                                        <input type="text" class="form-control"
                                                                            name="expire_sms_send_time"
                                                                            pattern="(0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]"
                                                                            placeholder="00:00 to 23:59"
                                                                            value="{{ $expire_sms_send_time }}">


                                                                        {{-- <input type="text" id="expire_sms_send_time" name="expire_sms_send_time" min="00:00" max="23:59" required> --}}
                                                                    </div>
                                                                </div>


                                                                <div class="w-100 border p-3">
                                                                    @if (auth()->user()->id == 1 || auth()->user()->email == 'admin@billingfix.xyz')
                                                                        <div class="w-100">
                                                                            <label>Deactive day after Expire</label>
                                                                            <input class="form-control " type="number"
                                                                                name="deactive_after"
                                                                                value="{{ $data->deactive_after }}"
                                                                                placeholder="Deactive after ">
                                                                        </div>

                                                                        <div class="w-100">
                                                                            <label>Billing Type</label>
                                                                            <select name="billing_type" id="billing_type"
                                                                                class="form-control">
                                                                                <option value="monthly"
                                                                                    @if ($billing_type == 'monthly') selected @endif>
                                                                                    Monthly Bill Generate
                                                                                </option>
                                                                                <option value="day_to_day"
                                                                                    @if ($billing_type == 'day_to_day') selected @endif>
                                                                                    Day to Day
                                                                                </option>
                                                                            </select>

                                                                        </div>
                                                                    @else
                                                                        <div class="w-100">
                                                                            <label for="">Billing Type</label>
                                                                            <p>{{ $billing_type }}</p>
                                                                            <hr>
                                                                            <input type="hidden"
                                                                                value="{{ $billing_type }}"
                                                                                name="billing_type">
                                                                        </div>
                                                                    @endif
                                                                </div>

                                                                <div class="w-100 border p-3">
                                                                    <div class="w-100">
                                                                        <label>Mikrotik Sync Time</label>
                                                                        <input class="form-control " type="number"
                                                                            name="sync_time_in_secconds"
                                                                            value="{{ $data->sync_time_in_secconds }}"
                                                                            placeholder="Enter Mikrotik Sync Time in seconds"
                                                                            required>
                                                                    </div>

                                                                    <div class="w-100">
                                                                        <label>Max Extended Day</label>
                                                                        <input class="form-control " type="number"
                                                                            name="max_extended_day"
                                                                            value="{{ $data->max_extended_day }}"
                                                                            placeholder="Enter Max Extended Day" required>
                                                                    </div>
                                                                    @if (globalPermission('show-message-to-expire-customer'))
                                                                        <div class="w-100">
                                                                            <div class="form-group do-float">
                                                                                <label>Expire Profile</label>
                                                                                <input class="form-control" type="text"
                                                                                    name="expire_profile"
                                                                                    placeholder="Expire Profile Name"
                                                                                    value="{{ $data->expire_profile }}">
                                                                            </div>
                                                                        </div>
                                                                    @endif
                                                                    @can('router-remote-access')
                                                                        <div class="w-100">
                                                                            <label>Remote Router Port</label>
                                                                            <input class="form-control " type="number"
                                                                                name="remote_router_port"
                                                                                value="{{ $data->remote_router_port ?? 8080 }}"
                                                                                placeholder="Remote Router Port">
                                                                        </div>
                                                                    @endcan

                                                                    <div class="w-100">
                                                                        <label>Host IP</label>
                                                                        <input class="form-control" type="text"
                                                                            name="hyper_host"
                                                                            value="{{ $data->hyper_host }}"
                                                                            placeholder="Enter Host IP Address">
                                                                    </div>

                                                                    <div class="w-100">
                                                                        <label>Host Port</label>
                                                                        <input class="form-control" type="number"
                                                                            name="hyper_port"
                                                                            value="{{ $data->hyper_port }}"
                                                                            placeholder="Enter Host Port">
                                                                    </div>
                                                                </div>

                                                                @can('stock-alert-number')
                                                                    @php
                                                                        $users_mobile_number = explode(
                                                                            ',',
                                                                            $data->stock_reminder_contact_numbers,
                                                                        );
                                                                        // dd($users_mobile_number);
                                                                    @endphp
                                                                    <div class="w-100 border p-3">
                                                                        <label for="invoice_terms">Stock Alert Sms </label>
                                                                        <select name="stock_reminder_sms_reciver_numbers[]"
                                                                            id="users" class="form-control select2 "
                                                                            multiple>
                                                                            <option value="">Select User</option>
                                                                            @foreach ($users as $user)
                                                                                <option value="{{ $user->mobile_number }}"
                                                                                    @if (in_array($user->mobile_number, $users_mobile_number)) selected @endif>
                                                                                    {{ $user->name }}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </div>
                                                                @endcan

                                                                <div class="w-100 border p-3">
                                                                    <div class="w-100">
                                                                        <div class="form-group do-float">
                                                                            <label>Company</label>
                                                                            <input class="form-control " type="text"
                                                                                name="name"
                                                                                placeholder="Enter Company Name"
                                                                                value="{{ $data->name }}">
                                                                        </div>
                                                                    </div>

                                                                    <div class="w-100">
                                                                        <div class="form-group do-float">
                                                                            <label>Email Address</label>
                                                                            <input class="form-control " type="email"
                                                                                name="email"
                                                                                placeholder="Enter Email Address"
                                                                                value="{{ $data->email }}">

                                                                        </div>
                                                                    </div>
                                                                    <div class="w-100">
                                                                        <div class="form-group do-float">
                                                                            <label>Phone</label>
                                                                            <input class="form-control " type="text"
                                                                                name="mobile"
                                                                                value="{{ $data->mobile }}"
                                                                                placeholder="Enter Mobile Number">

                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                <div class="w-100 border p-3 rounded span-3">
                                                                    <div class="w-100">
                                                                        <div class="form-group do-float">
                                                                            <label>Billing Contact No</label>
                                                                            <input class="form-control " type="text"
                                                                                name="billing_no"
                                                                                value="{{ $data->billing_no }}"
                                                                                placeholder="Enter Billing Contact No">
                                                                        </div>
                                                                    </div>
                                                                    <div class="w-100">
                                                                        <div class="form-group do-float">
                                                                            <label>Technical or Support No</label>
                                                                            <input class="form-control " type="text"
                                                                                name="technical_or_support_no"
                                                                                value="{{ $data->technical_or_support_no }}"
                                                                                placeholder="Enter Technical or Support No">
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                <div class="w-100 border p-3 rounded">

                                                                    <div class="w-100">
                                                                        <label>Address</label>
                                                                        <textarea name="address" id="address" class="form-control textarea">{!! $data->address !!}</textarea>
                                                                    </div>

                                                                </div>

                                                                <div class="w-100 border p-3 rounded">

                                                                    <div class="w-100">
                                                                        <label for="invoice_terms">Invoice Terms</label>
                                                                        <textarea name="invoice_terms" id="invoice_terms" class="form-control textarea">{!! $data->invoice_terms ?? '' !!}</textarea>
                                                                    </div>

                                                                </div>
                                                                <div class="w-100 border p-3 rounded">
                                                                    <div class="w-100">
                                                                        <label for="notification">Client
                                                                            Notification</label>
                                                                        <textarea name="notification" id="notification" class="form-control textarea">{!! $data->notification ?? '' !!}</textarea>
                                                                    </div>
                                                                </div>
                                                                @if (auth()->user()->email == 'rokibulhasan.356@gmail.com')
                                                                    <div class="w-100 border border-danger p-3 rounded">

                                                                        <div class="w-100">
                                                                            <label for="invoice_terms">Days (Day 2 Day
                                                                                Active After)</label>
                                                                            <input class="form-control " type="number"
                                                                                name="d2dactiveday"
                                                                                value="{{ $data->d2dactiveday }}"
                                                                                placeholder="Enter Technical or Support No">
                                                                        </div>

                                                                    </div>

                                                                    <div class="w-100 border border-danger p-3 rounded">
                                                                        <div class="form-group do-float">
                                                                            <label>D2D After Days Active</label>
                                                                            <h3
                                                                                class="lead text-uppercase text-danger font-weight-bold text-center border">
                                                                                {{ $data->day_to_day_after_10_days }}
                                                                            </h3>
                                                                            <div class="flex-grow border p-2 mt-3 rounded "
                                                                                style="bottom: 0; left:8px; right:8px;">
                                                                                <h5 class="h5"> Change </h5>
                                                                                <select name="day_to_day_after_10_days"
                                                                                    id="day_to_day_after_10_days"
                                                                                    class="form-control">
                                                                                    <option value="No"
                                                                                        @if ($data->day_to_day_after_10_days == 'No') selected @endif>
                                                                                        No
                                                                                    </option>
                                                                                    <option value="Yes"
                                                                                        @if ($data->day_to_day_after_10_days == 'Yes') selected @endif>
                                                                                        Yes
                                                                                    </option>
                                                                                </select>
                                                                            </div>

                                                                        </div>
                                                                    </div>

                                                                    <div class="w-100 border border-danger p-3 rounded">
                                                                        <div class="w-100">
                                                                            <label for="invoice_terms">Bill By Payment
                                                                                Start Date</label>
                                                                            <input class="form-control" type="date"
                                                                                name="bill_by_payment_start_time"
                                                                                value="{{ \Carbon\Carbon::parse($data->bill_by_payment_start_time)->format('Y-m-d') }}">
                                                                        </div>
                                                                    </div>
                                                                @endif
                                                                <div class="w-100 border border-danger p-3 rounded">
                                                                    <div class="w-100">
                                                                        <label for="min_recharge_amount">Minimum Amount For
                                                                            Online Recharge(Reseller)</label>
                                                                        <input class="form-control" type="number"
                                                                            name="min_recharge_amount"
                                                                            value="{{ $data->min_recharge_amount }}">
                                                                    </div>
                                                                </div>
                                                            </div>

                                                        </div>


                                                        @if (checkSettings('telegram-notify') == 'enable')
                                                            <h2 class="mt-5 page-header">Telegram Notification</h2>
                                                            <div class="row">


                                                                <div class="col-md-6">
                                                                    <div class="form-group do-float">
                                                                        <label>Telegram Group Name</label>
                                                                        <input class="form-control " type="text"
                                                                            id="telegram_group_name"
                                                                            name="telegram_group_name"
                                                                            value="{{ $telegram[0]->group_name ?? '' }}"
                                                                            autocomplete="off"
                                                                            placeholder="Enter Group Name">

                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group do-float">
                                                                        <label>Telegram Api</label>
                                                                        <input class="form-control " type="text"
                                                                            id="telegram_api" name="telegram_api"
                                                                            value="{{ $telegram[0]->api ?? '' }}"
                                                                            autocomplete="off" placeholder="Enter Api">

                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group do-float">
                                                                        <label>Telegram Chat Id</label>
                                                                        <input class="form-control " type="text"
                                                                            id="telegram_chat_id" name="telegram_chat_id"
                                                                            value="{{ $telegram[0]->chat_id ?? '' }}"
                                                                            autocomplete="off"
                                                                            placeholder="Enter Chat Id">

                                                                    </div>
                                                                </div>
                                                                <div class="form-check mt-4 ml-2">
                                                                    <input class="form-check-input" type="checkbox"
                                                                        value="{{ $data->same_for_support ? 1 : 2 }}"
                                                                        name="support_notification_telegram"
                                                                        id="support_notification_telegram"
                                                                        @if ($data->same_for_support == true) checked @endif>
                                                                    <label class="form-check-label"
                                                                        for="flexCheckChecked">
                                                                        <strong>Same group for support notification</strong>
                                                                    </label>
                                                                </div>
                                                            </div>
                                                            <h2 class="mt-5 page-header">Telegram Notification For Support
                                                            </h2>
                                                            <div class="row">


                                                                <div class="col-md-6">
                                                                    <div class="form-group do-float">
                                                                        <label>Telegram Group Name</label>
                                                                        <input class="form-control " type="text"
                                                                            id="telegram_group_name_support"
                                                                            name="telegram_group_name_support"
                                                                            value="{{ $telegram_support[0]->group_name ?? '' }}"
                                                                            autocomplete="off"
                                                                            placeholder="Enter Group Name">

                                                                    </div>
                                                                </div>

                                                                <div class="col-md-6">
                                                                    <div class="form-group do-float">
                                                                        <label>Telegram Api</label>
                                                                        <input class="form-control" type="text"
                                                                            id="telegram_api_support"
                                                                            name="telegram_api_support"
                                                                            value="{{ $telegram_support[0]->api ?? '' }}"
                                                                            autocomplete="off" placeholder="Enter Api">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group do-float">
                                                                        <label>Telegram Chat Id</label>
                                                                        <input class="form-control" type="text"
                                                                            id="telegram_chat_id_support"
                                                                            name="telegram_chat_id_support"
                                                                            value="{{ $telegram_support[0]->chat_id ?? '' }}"
                                                                            autocomplete="off"
                                                                            placeholder="Enter Chat Id">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endif

                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane fade" id="custom-tabs-one-bill-payment" role="tabpanel"
                                aria-labelledby="custom-tabs-one-bill-payment-tab">
                                <div class="container col-md-12">
                                    <div class="card-body">


                                        <div class="w-50">
                                            <h2 class="mt-5 page-header">3rd Party Payment Url
                                                <input type="checkbox" name="payment_url_enable"
                                                    {{ $payment->payment_url_enable == 'on' ? 'checked' : '' }}>
                                            </h2>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <input type="text" name="payment_url" class="form-control"
                                                        value="{{ $payment->payment_url }}">
                                                </div>
                                            </div>
                                        </div>

                                        <h2 class="mt-5 page-header">Image For Payment Button</h2>

                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group do-float">
                                                    <div class="col-md-6"><label>Bkash Image</label></div>
                                                    <input type="file" name="bkash_img" accept="image/*">

                                                    @if (isset($payment_button->where('type', 'bkash_img')->first()->value))
                                                        <img width="100" height="100"
                                                            src="{{ asset('storage/company/' . $payment_button->where('type', 'bkash_img')->first()->value) }}"
                                                            alt="No Image">
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group do-float">
                                                    <div class="col-md-6"><label>SSL Image</label></div>
                                                    <input type="file" name="ssl_img" accept="image/*">

                                                    @if (isset($payment_button->where('type', 'ssl_img')->first()->value))
                                                        <img width="100" height="100"
                                                            src="{{ asset('storage/company/' . $payment_button->where('type', 'ssl_img')->first()->value) }}"
                                                            alt="No Image">
                                                    @endif

                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group do-float">
                                                    <div class="col-md-6"> <label>Nagod Image</label></div>
                                                    <input type="file" name="nagod_img" accept="image/*">
                                                    @if (isset($payment_button->where('type', 'nagod_img')->first()->value))
                                                        <img width="100" height="100"
                                                            src="{{ asset('storage/company/' . $payment_button->where('type', 'nagod_img')->first()->value) }}"
                                                            alt="No Image">
                                                    @endif
                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <div class="form-group do-float">
                                                    <div class="col-md-6"> <label>Upay Image</label></div>
                                                    <input type="file" name="upay_image" accept="image/*">
                                                    @if (isset($payment_button->where('type', 'upay_img')->first()->value))
                                                        {{-- @php
                                                        dd("comes");
                                                    @endphp --}}
                                                        <img width="100" height="100"
                                                            src="{{ asset('storage/company/' . $payment_button->where('type', 'upay_img')->first()->value) }}"
                                                            alt="No Image">
                                                    @endif
                                                </div>
                                            </div>


                                        </div>

                                    </div>

                                </div>
                            </div>

                            <div class="tab-pane fade" id="yetfix-notice" role="tabpanel"
                                aria-labelledby="yetfix-notice-tab">
                                <div class="container col-md-12">

                                    @php
                                        $telegram = json_decode($data->telegram);
                                        $telegram_support = json_decode($data->telegram_for_support);
                                    @endphp



                                    {{-- <h4 class="card-title fw-400" style="margin-left: 20px; margin-top: 20px">
                                                        Company Details</h4> --}}
                                    <div class="card-body">

                                        @if (auth()->user()->id == 1 || auth()->user()->email == 'admin@billingfix.xyz')
                                            <div class="col-md-12 bg-danger pb-2">
                                                <div class="row p-2">
                                                    <div class="col-md-3">
                                                        <label for="customer_panel_url">Customer Panel Url</label>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <input type="text" name="customer_panel_url"
                                                            id="customer_panel_url" class="form-control"
                                                            value="{{ $customer_panel_api->customer_panel_url ?? '' }}">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label for="panel_secret">Panel Secret</label>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <input type="text" name="customer_panel_secret"
                                                            id="customer_panel_secret" class="form-control"
                                                            value="{{ $customer_panel_api->customer_panel_secret ?? '' }}">
                                                    </div>
                                                </div>

                                                <hr>

                                                <div class="row p-2">


                                                    <div class="col-md-12 row">
                                                        <div class="col-md-3">
                                                            <label>Yetfix Notice Show</label>
                                                        </div>
                                                        <div class="col-md-3 ml-1">
                                                            <select name="notice_yes_no" id="notice_yes_no"
                                                                class="form-control ">
                                                                <option value="Yes"
                                                                    @if ($data->notice_yes_no == 'Yes') selected @endif>
                                                                    Yes
                                                                </option>
                                                                <option value="No"
                                                                    @if ($data->notice_yes_no == 'No') selected @endif>
                                                                    No
                                                                </option>
                                                            </select>
                                                        </div>
                                                        <div class="col-md-1">
                                                            <label>License Check</label>
                                                        </div>
                                                        <div class="col-md-2">
                                                            <select name="client_license_check" id="" class="form-control">
                                                                <option value="">Select One</option>
                                                                @if (isset($customer_panel_api->client_license_check))
                                                                    <option value="true"
                                                                        {{ $customer_panel_api->client_license_check == "true" ? 'selected' : '' }}>
                                                                        True</option>
                                                                    <option value="false"
                                                                        {{ $customer_panel_api->client_license_check == "false" ? 'selected' : '' }}>
                                                                        False</option>
                                                                @else
                                                                    <option value="true"
                                                                        {{ $CLIENT_LICENSE_CHECK == true ? 'selected' : '' }}>
                                                                        True</option>
                                                                    <option value="false"
                                                                        {{ $CLIENT_LICENSE_CHECK == false ? 'selected' : '' }}>
                                                                        False</option>
                                                                @endif
                                                            </select>
                                                        </div>
                                                        <div class="col-md-1">
                                                            <label>Check Time</label>
                                                        </div>
                                                        <div class="col-md-1">
                                                            <input type="text" name="" id=""
                                                                class="form-control"
                                                                value="{{ $CLIENT_LICENSE_CHECK_TIME ?? '' }}">
                                                        </div>
                                                    </div>
                                                    {{-- <div class="col-md-8">
                                                        <label>Notice Text</label>
                                                        <textarea name="notice" id="notice" rows="3" class="form-control ">{{ $data->notice ?? '' }}</textarea>
                                                    </div> --}}
                                                </div>
                                            </div>
                                        @else
                                            <div class="col-md-3">
                                                <input type="hidden" name="customer_panel_url" id="customer_panel_url"
                                                    class="form-control"
                                                    value="{{ $customer_panel_api->customer_panel_url ?? '' }}">
                                            </div>

                                            <div class="col-md-3">
                                                <input type="hidden" name="customer_panel_secret"
                                                    id="customer_panel_secret" class="form-control"
                                                    value="{{ $customer_panel_api->customer_panel_secret ?? '' }}">
                                            </div>

                                            <div class="col-md-3">
                                                <input type="hidden" name="client_license_check"
                                                    id="client_license_check" class="form-control"
                                                    value="{{ $customer_panel_api->client_license_check ?? '' }}">
                                            </div>
                                        @endif

                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="float-right mt-2">
                    <button class="btn btn-primary" type="submit">Save Changes</button>
                </div>
            </form>

        </div>
    </div>
@endsection

@section('ajax')
    <link href="{{ asset('/') }}plugins/summernote/summernote-bs4.css" rel="stylesheet">
    <script src="{{ asset('/') }}plugins/summernote/summernote-bs4.js"></script>
    <script>
        function onlinePaymentUrl() {
            var appUrl = "{{ config('app.url') }}/clientPaymentSearch"; // Get APP_URL from .env
            navigator.clipboard.writeText(appUrl).then(function() {
                alert("Online Payment Url copied to clipboard!");
            }).catch(function(error) {
                alert("Failed to copy URL: " + error);
            });
        }
    </script>
    <script>
        $(document).ready(function() {
            $('.textarea').summernote({
                height: 100,
            });

            $("#sync-mikrotik-ip-to-software").click((event) => {
                event.preventDefault();
                $.ajax({
                    url: "{{ route('sync-client-ip-to-software') }}",
                    type: "Post",
                    success: () => {
                        toastr.success("ip address successfully synced to software.")
                    },
                    error: () => {
                        toastr.error("something went wrong while syncing ip address.")
                    }
                })
            })
            $("#sync-mikrotik-mac-to-software").click((event) => {
                event.preventDefault();
                $.ajax({
                    url: "{{ route('sync-client-mac-to-software') }}",
                    type: "Post",
                    success: () => {
                        toastr.success("Mac successfully synced to software.")
                    },
                    error: () => {
                        toastr.error("something went wrong while syncing ip address.")
                    }
                })
            })

            $("#sync-online-client-mac-to-software").click((event) => {
                event.preventDefault();
                $.ajax({
                    url: "{{ route('sync-online-client-mac-to-software') }}",
                    type: "Post",
                    success: () => {
                        toastr.success("Mac successfully synced to software.")
                    },
                    error: () => {
                        toastr.error("something went wrong while syncing ip address.")
                    }
                })
            })
            $("#client-online-ip-add-to-static-ip").click((event) => {
                event.preventDefault();
                $.ajax({
                    url: "{{ route('client-online-ip-add-to-static-ip') }}",
                    type: "Post",
                    success: () => {
                        toastr.success("Ip successfully synced to software.")
                    },
                    error: () => {
                        toastr.error("something went wrong while syncing ip address.")
                    }

                })
            })

            $('#support_notification_telegram').change(function() {
                if ($(this).is(':checked')) {
                    console.log('change');

                    var name = $('#telegram_group_name').val();
                    console.log(name);
                    name = name + " (Support)";
                    $('#telegram_group_name_support').val(name);
                    $('#telegram_api_support').val($('#telegram_api').val());
                    $('#telegram_chat_id_support').val($('#telegram_chat_id').val());
                    $('#support_notification_telegram').val(1);
                } else {
                    console.log('not check change');

                    $('#telegram_group_name_support').val('');
                    $('#telegram_api_support').val('');
                    $('#telegram_chat_id_support').val('');
                    $('#support_notification_telegram').val(2);

                }
            });

        });
    </script>
@endsection



<style>
    @media (max-width:768px) {
        .card-body {
            padding: 0.25rem !important;
        }
    }

    .change-logo {
        --tw-bg-opacity: 1;
        background-color: rgb(75 85 99 / var(--tw-bg-opacity));
        --tw-text-opacity: 1;
        color: rgb(255 255 255 / var(--tw-text-opacity));
    }

    .change-logo:hover {
        background-color: rgb(75 85 99 / 0.8);
        transition-delay: 200ms;
        transition-duration: 150ms;

    }

    .site-settings {
        display: grid;
        grid-template-columns: repeat(1, minmax(0, 1fr));
        gap: 10px;
        width: 100% !important;
    }





    @media(min-width:1280px) {
        .site-settings {
            grid-template-columns: repeat(3, minmax(0, 1fr));
        }

    }
</style>
