@extends('layout.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-white py-3">
                    <h4 class="card-title m-0 font-weight-bold text-primary">Remarks List For New Line Request</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="px-6 text-left text-sm font-medium">SL</th>
                                    <th class="px-6 text-left text-sm font-medium">Remarks</th>
                                    <th class="px-6 text-left text-sm font-medium">Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($remarks as $index => $remark)
                                    <tr>
                                        <td class="px-6 text-left text-sm font-medium">{{ $index + 1 }}</td>
                                        <td class="px-6 text-left text-sm font-medium">{{ $remark->remarks }}</td>
                                        <td class="px-6 text-left text-sm font-medium">{{ $remark->created_at->format('Y-m-d h:i A') }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <form action="{{ route('new-line-request.remark', $new_line_request) }}" method="POST" class="mt-4">
                        @csrf
                        <div class="form-group">
                            <label for="remarks">Add Remark</label>
                            <textarea name="remarks" id="remarks" class="form-control" rows="4" required></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary">Submit Remark</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
