@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="" id="search" class="resellerRechargeLog">

                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">From Date</label>
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input type="text" name="from_date" value="{{ $start->format('m/d/y') }}"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">To Date</label>
                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input type="text" name="to_date" value="{{ $end->format('m/d/y') }}"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label>User</label>
                            <select name="user" id="" class="form-control select2">
                                <option value="">Select One</option>
                                @forelse ($users as $row)
                                    <option value="{{ $row->id }}">{{ $row->name }}</option>
                                @empty
                                @endforelse
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Employee</label>
                            <select name="employee" id="" class="form-control select2">
                                <option value="">Select One</option>
                                @forelse ($employees as $item)
                                    <option value="{{ $item->id }}">{{ $item->name }}</option>
                                @empty
                                @endforelse
                            </select>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group float-right mt-2">
                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i> Search</button>
                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>

                </div>

                <div id="result"></div>

            </form>
        </div>
    </div>
@endsection

@section('ajax')
    <script type="text/javascript">
        $(function() {
            $('#reset').click(function() {
                $('#result').html('');
            });

            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $('body').append('<div id="loading">Loading.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('userWiseTokenReport') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                        $('#loading').remove();
                    }
                });
            });

        });
    </script>
@endsection
