@extends('layout.app')
@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('permissions.update', $permission->id) }}" method="POST">
                @method('put')
                @csrf

                <div class="row">
                    <div class="form-group col-md-4">
                        <label for="name" class="block text-sm font-medium text-gray-700">
                            Permission Name*
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">
                            <input type="hidden" value="{{ $permission->id }}">
                            <input type="text" name="name" id="name" value="{{ $permission->name }}" class="form-control"
                                placeholder="Permission Name" autocomplete="off">
                        </div>
                        @error('name')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="status" class="block text-sm font-medium text-gray-700">
                            Permission Status*
                        </label>

                        <select name="status" id="status" class="select2 form-control">
                            <option value="">Select Status</option>
                            <option value="enable" @if ($permission->status == 'enable') {{ 'selected' }} @endif>Enable
                            </option>
                            <option value="disable" @if ($permission->status == 'disable') {{ 'selected' }} @endif>disable
                            </option>
                        </select>

                        @error('status')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
                <div class="form-group col-md-10">
                    <a href="{{ route('permissions.index') }}" class="btn-black "> <i class="fa fa-arrow-left"></i>
                        Back to Permission List</a>

                    <button type="submit" class="btn btn-primary float-right">
                        Save
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection
