<div class="table-responsive" id="result">

    <div class="col-md-12">

        <div class="badge badge-info badge-custom font-large">Total Row: {{ $billGenerates->groupBy('client_id')->count() }}</div>
        <div class="badge badge-info badge-custom font-large">Total Bill: {{ $billGenerates->sum('bill_amount') }}</div>
        <div class="badge badge-info badge-custom font-large">Total Paid: {{ $billGenerates->sum('paid_amount') }}</div>
        <div class="badge badge-info badge-custom font-large">Total Due: {{ $billGenerates->sum('bill_amount') - $billGenerates->sum('paid_amount') }}</div>
    </div>
    <table class="table table-bordered table-striped table-condensed">
        <thead>
            <tr class="bg-black">
                <th>ID</th>
                <th>User ID</th>
                <th>User Name</th>
                <th>User Contact No</th>
                <th>POP</th>
                <th>Total Bill</th>
                <th>Total Paid</th>
                <th>Total Due</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($billGenerates->groupBy('client_id') as $clientId => $bills)
                @php
                    $latestBill = $bills->last();
                @endphp
                <tr>
                    <td>{{ $latestBill->clients->id }}</td>
                    <td>{{ $latestBill->clients->userid }}</td>
                    <td>{{ $latestBill->clientsinfo->clients_name }}</td>
                    <td>{{ $latestBill->clientsinfo->contact_no }}</td>
                    <td>{{ $latestBill->clients->pops->popname }}</td>
                    <td>{{ $bills->sum('bill_amount') }}</td>
                    <td>{{ $bills->sum('paid_amount') }}</td>
                    <td>{{ $bills->sum('bill_amount') - $bills->sum('paid_amount') }}</td>
                </tr>
            @endforeach
            <tr>
                <td colspan="5" class="text-center font-weight-bold">Sum</td>
                <td>{{ $billGenerates->sum('bill_amount') }}</td>
                <td>{{ $billGenerates->sum('paid_amount') }}</td>
                <td>{{ $billGenerates->sum('bill_amount') - $billGenerates->sum('paid_amount') }}</td>
            </tr>
        </tbody>
    </table>

    <style>
        .font-large {
            font-size: 1.5rem; /* Adjust size as needed */
            font-weight: bold; /* Optional for emphasis */
        }
    </style>
</div>
