import { createSlice } from "@reduxjs/toolkit";

const initialState = {
    currentCluster: null,
    openClusterView: false,
    viewKey: "view",
};

const deviceReducer = {
    addDevice(state, action) {
        state.currentCluster.devices.push(action.payload);
        return state;
    },

    removeDevice(state, action) {
        state.currentCluster.devices = state.currentCluster.devices.filter(
            (device) => device.id !== action.payload
        );
        return state;
    },

    updateDevice(state, action) {
        state.currentCluster.devices = state.currentCluster.devices.map(
            (device) => {
                if (device.id === action.payload.id) {
                    return action.payload;
                }
                return device;
            }
        );
        return state;
    },
};

const splitterReducer = {
    addSplitter(state, action) {
        state.currentCluster.splitters.push(action.payload);
        return state;
    },

    removeSplitter(state, action) {
        state.currentCluster.splitters = state.currentCluster.splitters.filter(
            (splitter) => splitter.id !== action.payload
        );
        return state;
    },

    updateSplitter(state, action) {
        state.currentCluster.splitters = state.currentCluster.splitters.map(
            (splitter) => {
                if (splitter.id === action.payload.id) {
                    return action.payload;
                }
                return splitter;
            }
        );
        return state;
    },
};

const onuReducer = {
    addOnu(state, action) {
        state.currentCluster.onus.push(action.payload);
        return state;
    },

    removeOnu(state, action) {
        state.currentCluster.onus = state.currentCluster.onus.filter(
            (onu) => onu.id !== action.payload
        );
        return state;
    },

    updateOnu(state, action) {
        state.currentCluster.onus = state.currentCluster.onus.map((onu) => {
            if (onu.id === action.payload.id) {
                return action.payload;
            }
            return onu;
        });
        return state;
    },
};

const reducers = {
    setCurrentCluster(state, action) {
        state.currentCluster = action.payload;
        return state;
    },

    removeCurrentCluster(state) {
        state.currentCluster = null;
        return state;
    },

    setOpenClusterView(state, action) {
        if (action.payload === false) {
            state.viewKey = "view";
            state.currentCluster = null;
            state.openClusterView = false;
            return state;
        }
        state.openClusterView = action.payload;
        return state;
    },

    updateClusterView(state, action) {
        state.currentCluster = { ...state.currentCluster, ...action.payload };
        return state;
    },

    setViewKey(state, action) {
        state.viewKey = action.payload;
        return state;
    },

    ...deviceReducer,
    ...splitterReducer,
    ...onuReducer,
};

const currentClusterReducer = createSlice({
    name: "currentClusterReducer",
    initialState,
    reducers,
});

export const {
    setCurrentCluster,
    updateClusterView,
    setOpenClusterView,
    removeCurrentCluster,
    setViewKey,

    addDevice,
    removeDevice,
    updateDevice,

    addSplitter,
    removeSplitter,
    updateSplitter,

    addOnu,
    removeOnu,
    updateOnu,
} = currentClusterReducer.actions;

export default currentClusterReducer.reducer;
