<?php

namespace App\Console\Commands;

use App\Models\Client;
use App\Services\ExpirationService;
use App\Services\RadiusClientSync;
use Illuminate\Console\Command;

class SyncAllCustomer extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sync:all-customer';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Synchronize all customers.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $clients = Client::with('pops.nas', 'packages')->get();

        foreach ($clients as $client) {
            if(globalPermission('RadiusExpiration')){
                (new ExpirationService())->syncExpiration($client->userid);
            }else{
                (new RadiusClientSync())->syncSingleRadiusClient($client->id);
            }
        }
    }
}
