<?php
namespace App\Classes;


use App\Models\Token;
use App\Jobs\SendSmsJob;
use App\Models\Employee;
use Illuminate\Http\Request;
use App\Classes\Notification;
use Illuminate\Support\Facades\DB;


class TokenClass{

    public function saveToken(Request $request){
        $token = new Token();
        $token->tokenCategory = $request->tokenCategory;
        $token->tokenCode = $request->tokenCode;
        $token->description = $request->description;
        $token->reportedBy = $request->reportedBy;
        $token->reporterContact = $request->reporterContact;
        $token->clientId = $request->clientId;
        $token->createdBy = auth()->user()->id;
        if (checkSettings('token_source') == 'enable'){
            if (auth()->user()->hasPermissionTo('default_source_crm')){
                $token->token_source = 'CRM';
            } else{
                $token->token_source = $request->token_source ?? null;
            }
        }
        $token->save();

        if(isset($request->employee)){
            if($request->employee != null){
                $token->assignToken = $request->employee;
                $token->assignUserId = auth()->user()->id;
                $token->assign_time = now();
                $token->save();
            }
        }
        $token->token = $token->id + 1000000;
        $token->save();

        return $token;

    }
}


