<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePaymentGetwayCredentialsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payment_getway_credentials', function (Blueprint $table) {
            $table->id();
            $table->integer('reseller_id');
            $table->string('getway_name');
            $table->longText('appkey_publickey');
            $table->longText('secretkey_privatekey');
            $table->string('username_merchantid');
            $table->string('password_merchantnumber');
            $table->string('callback_url');
            $table->string('base_url');
            $table->string('payer_reference');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_getway_credentials');
    }
}
