<?php

namespace App\Http\Controllers;

use App\Models\BillGenerate;
use App\Models\Client;
use App\Models\Clientsinfo;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;


class DeleteClientInfoController extends Controller
{
    public function deleteAllCustomerInfoAndAccountByPopId()
    {
        return view('deleteCustomerAccounte.index');
    }

    public function deleteCustomerAccount(Request $request)
    {
       $pop_list = explode(',', $request->pop_id);
    //    dd($pop_list);

       foreach ($pop_list as $pop_id) {
           $clients = Client::where('pop_id', $pop_id)->get();
           foreach ($clients as $client) {
            //    dd($client);
                DB::beginTransaction();
                try{

                    // Clientsinfo::where('client_id', $client->id)->delete();
                    // Client::where('id', $client->id)->delete();
                    DB::table('clientsinfo')->where('client_id', $client->id)->delete();
                    DB::table('clients')->where('id', $client->id)->delete();
                    // dd($client->userid);
                    if(!checkAPI()){
                        DB::table('radusergroup')->where('username', $client->userid)->delete();
                        DB::table('radcheck')->where('username', $client->userid)->delete();
                    }
                    DB::commit();
                    // return redirect()->back();
                }catch(\Exception $e){
                    DB::rollback();
                    Toastr::error('Something went wrong', 'Error');
                    return redirect()->back();
                }
           }
       }

       Toastr::success('All Customer Account Deleted Successfully', 'Success');
         return redirect()->back();
    }


    public function currentMonthCustomerInfo()
    {
        $start = Carbon::parse(date('Y-m-01'))->format('Y-m-d 00:00:00');
        $end = Carbon::parse(today())->format('Y-m-d 23:59:59');

        $clients = Client::with('currentMonthgeneratedBill','currentMonthpaymentBill','clientsInfo','currentmonthbalanceAdjustment','customerAccount')->get();

        $data =[
            'clients' => $clients,
        ];

        return view('deleteCustomerAccounte.currentmonthclientaccount', $data);
    }


    public function deleteAllBillNotPaid(){
        $billgenerates = BillGenerate::where('paid_amount', 0)->get();

        foreach($billgenerates as $item){
           (new BillGenerateController())->monthlyBillFix(request(),$item->id);
        }

        Toastr::success('All Bill Not Paid Deleted Successfully', 'Success');
        return redirect()->back();

    }


    public function fixedExpiresDate(){

        $start = Carbon::parse(date('Y-m-01'))->format('Y-m-d 00:00:00');
        $end = Carbon::parse(today())->format('Y-m-d 23:59:59');
        $clients = Client::with('customerAccount')
        ->whereHas('customerAccount', function ($query)  {
            $query->where('dueAmount', '<=', 0);
        })->whereHas('generatedBill', function ($query) use ($start, $end) {
            $query->where('billing_type','monthly')->whereBetween('created_at', [$start, $end]);
        })->whereHas('pop', function ($query) {
            $query->where('bill_generate', 'yes');
        })
        ->get();
        // dd($clients);
        foreach($clients as $client){
            $billiing_cycle = $client->billing_cycle;
            $expire_date = Carbon::parse(date("Y-m-".$billiing_cycle))->format('Y-m-d 00:00:00');
            Client::where('id',$client->id)->update(['expire_date' => Carbon::parse($expire_date)->addMonth()]);
            // dd($client);
        }

        // dd($clients);

        Toastr::success('All Customer expire date Successfully updated', 'Success');
        return redirect()->back();
    }

    public function fixedAllCustomerBillingCycle(){
        $clients = Client::get();

        foreach($clients as $client){
            $expire_date = $client->expire_date;
            $billing_cycle = Carbon::parse($expire_date)->format('d');
            Client::where('id',$client->id)->update(['billing_cycle' => $billing_cycle]);
        }

        Toastr::success('All Customer billing cycle update Successfully updated', 'Success');
        return redirect()->back();
    }


}
