<?php

namespace App\Http\Controllers\BandwidthSale;

use App\Http\Controllers\Controller;
use App\Models\BwCustomer;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;

class BandwidthClientController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = [
            'list' => BwCustomer::all()
        ];
        return view('bandwidth-sale.bw-customer.index', $data);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('bandwidth-sale.bw-customer.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $this->validate(
            $request,
            [
                'email' => 'required|string|email|max:255|unique:users'
            ],
        );


        $customer = new BwCustomer();
        $customer->fill($request->all());

        $customer->save();

        Toastr::success('Information inserted Successfully!.', '', ["closeButton" => "true", "progressBar" => "true"]);
        return redirect()->route('bw-customer.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = [
            'customer' => BwCustomer::find($id)
        ];

        return view('bandwidth-sale.bw-customer.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate(
            $request,
            [
                'email' => 'required|string|email|max:255|unique:users'
            ],
        );


        $customer = BwCustomer::find($id);
        $customer->fill($request->all());

        $customer->update();
        Toastr::success('Information Update Successfully!.', '', ["closeButton" => "true", "progressBar" => "true"]);
        return redirect()->route('bw-customer.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
