<?php

namespace App\Classes\SMS;

use App\Jobs\ResellerSendSms;
use App\Jobs\SendSmsJob;
use App\Models\Client;
use App\Models\CompanyInformation;
use App\Models\ResellerSmsGetway;
use Carbon\Carbon;

class ResellerRechargeSms
{
    public function send($client_id)
    {
        $company_info = CompanyInformation::latest()->first();
        $sms_setting = json_decode(getSmsMessage()->where('tamplate_name', 'reseller_customer_recharge')->first()->tamplate_body, true);
        $sms_send = $sms_setting["sendsms"];
        $message = $sms_setting["sms_body"];
        $client = Client::with('clientsinfo', 'pop')->where('id', $client_id)->first();
        $month = date("F", strtotime($client->expire_date));

        if ($sms_send == "Yes") {
            $message = str_replace(
                [
                    '{c_id}',
                    '{c_code}',
                    '{c_password}',
                    '{c_username}',
                    '{c_name}',
                    '{c_deadline}',
                    '{month}',
                    '{company_name}',
                    '{company_cell}',
                ],
                [
                    $client->id,
                    $client->customer_code,
                    $client->password,
                    $client->userid,
                    $client->clientsinfo->clients_name,
                    $client->expire_date,
                    $month,
                    $company_info->name,
                    $company_info->mobile,
                ],
                $message
            );

            $data = [
                'message' => $message,
                'contact_no' => $client->clientsinfo->contact_no,
                'type' => 'reseller_customer_recharge'
            ];

            if (!empty($client->clientsinfo->contact_no)) {
                SendSmsJob::dispatch($data);
            }
        }
    }


    public function sendOtherResellerCustomerRechargeSms($client, $gatway, $reseller_name, $reseller_cell, $message, $reseller_id)
    {
        $month = date("F", strtotime($client->expire_date));

        $message = str_replace(
            [
                '{c_id}',
                '{c_code}',
                '{c_password}',
                '{c_name}',
                '{c_username}',
                '{c_expire_date}',
                '{month}',
                '{package_price}',
                '{reseller_name}',
                '{reseller_mobile}'
            ],
            [
                $client->id,
                $client->customer_code,
                $client->password,
                $client->clientsinfo->clients_name ?? '',
                $client->userid,
                $client->expire_date,
                $month,
                $client->packages->package_rate,
                $reseller_name,
                $reseller_cell
            ],
            $message
        );

        $contact = $client->clientsinfo->contact_no;
        // dd($contact);
        $data = [
            'reseller_id' => $reseller_id,
            'contact' => $contact,
            'message' => $message,
            'type' => "Reseller Customer Recharge",
            'api' => $gatway

        ];
        ResellerSendSms::dispatch($data);
    }
}
