@extends('layout.app')


@section('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{ asset('admin/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
@endsection

@section('content')
@php
    use App\Models\Client;
@endphp
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="card card-body">
                        <form action="{{ route('client-summary-report') }}" method="get" id="search">
                            <div class="row">
                                <div class="form-group col-md-2">
                                    <select class="form-control form-control-sm select2" name="month_year">
                                        <option value="">Select Month</option>
                                        @foreach ($allMonths as $month)
                                            <option value="{{ $month->id }}">{{ $month->month_year }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>



                                <div class="col-lg-2 col-md-2 col-sm-6 col-xs-6">
                                    <button type="submit" id="searchBtn" class="btn btn-primary btn-block form-control">
                                        Search
                                    </button>
                                </div>

                                <div class="col-lg-2 col-md-2 col-sm-6 col-xs-6">
                                    <a class="btn btn-warning btn-block form-control"
                                        href="{{ route('client-summary-report') }}">
                                        Reset
                                    </a>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title" style="color:#115548;">Client List</h3>
                            <div class="card-tools">
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="dataTable" class="display">
                                    <thead>
                                        <tr>
                                            <th>Active Client Id </th>
                                            <th>Current Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($activeClients as $clientId)
                                            <tr>
                                                <td>{{ $clientId }}</td>
                                                <td>
                                                    @if (isset($currentClients[$clientId]))
                                                        {{ $currentClients[$clientId] ?? 'N/A' }}
                                                    @else
                                                        @php
                                                            $checkClose = Client::onlyTrashed()->where('id', $clientId)->first();
                                                        @endphp
                                                        @if ($checkClose)
                                                            Closed
                                                        @else
                                                            Deleted
                                                        @endif

                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>

                        </div>

                    </div>
                    <!-- /.card -->

                </div>
            </div>
            <!-- /.row -->



        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
@endsection
@section('js')
    <!-- DataTables -->
    <script src="{{ asset('admin/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('admin/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('admin/plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('admin/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
@endsection
@push('script')
    <!-- page script -->
    <script>
        $(function() {
            $("#example1").DataTable({
                "responsive": true,
                "autoWidth": false,
            });
            $('#example2').DataTable({
                "paging": true,
                "lengthChange": false,
                "searching": false,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "responsive": true,
            });
        });
    </script>
@endpush
