import { useState } from "react";
import { Button, Col, Container, Form, Row } from "react-bootstrap";
import DeviceB from "./DeviceB";
import DeviceA from "./DeviceA";
import { toast } from "react-hot-toast";
import axiosInstance from "../../../../../../util/axiosInstance";

const getStreamOfCable = (cluster, cable) => {
    const upStream = cluster.up_stream.find((c) => c.id === cable.id);
    if (upStream) return "end";
    const downStream = cluster.down_stream.find((c) => c.id === cable.id);
    if (downStream) return "start";
};

const ConnectDevices = ({ cluster }) => {
    const [deviceLocation, setDeviceLocation] = useState("local");
    const [cable, setCable] = useState(null);

    const [componentAOption, setComponentAOption] = useState(null);
    const [componentBOption, setComponentBOption] = useState(null);

    const [componentA, setComponentA] = useState(null);
    const [componentB, setComponentB] = useState(null);

    const [cableFiber, setCableFiber] = useState(null);

    const [pointA, setPointA] = useState(null);
    const [pointB, setPointB] = useState(null);

    const onSubmitHandler = async (event) => {
        event.preventDefault();

        if (deviceLocation !== "local" && cableFiber == null) {
            toast.error("Please select a cable/fiber");
            return;
        }

        let cableStream = null;
        if (deviceLocation !== "local") {
            cableStream = getStreamOfCable(cluster, cable);
        }

        const requestData = {
            isFromCable: deviceLocation === "local" ? false : true,
            component_a: {
                id: componentA?.id,
                type: componentAOption === "device" ? "port" : componentAOption,
                pointId: pointA,
            },
            component_b: {
                id: componentB?.id,
                type: componentBOption === "device" ? "port" : componentBOption,
                pointId: pointB,
            },
            fiber: cableFiber,
            stream: cableStream,
        };
        console.table(requestData);

        try {
            const { data } = await axiosInstance.post("/connect", requestData);

            toast.success(data.message);
        } catch (error) {
            toast.error(error.response.data.error);
        }
    };

    return (
        <Container fluid>
            <h4>Connect Devices</h4>
            <hr className="mt-2 mb-3" />
            <Form onSubmit={onSubmitHandler}>
                <Row className="mb-5">
                    <Col lg={6}>
                        <DeviceA
                            cluster={cluster}
                            setPort={setPointA}
                            setCableFiber={setCableFiber}
                            deviceLocation={deviceLocation}
                            setDeviceLocation={setDeviceLocation}
                            componentOption={componentAOption}
                            setComponentOption={setComponentAOption}
                            component={componentA}
                            setComponent={setComponentA}
                            cable={cable}
                            setCable={setCable}
                        />
                    </Col>
                    <Col lg={6}>
                        <DeviceB
                            cluster={cluster}
                            setPort={setPointB}
                            componentOption={componentBOption}
                            setComponentOption={setComponentBOption}
                            component={componentB}
                            setComponent={setComponentB}
                        />
                    </Col>
                </Row>
                <div className="text-center">
                    <Button type="submit" variant="warning">
                        Connect
                    </Button>
                </div>
            </Form>
        </Container>
    );
};

export default ConnectDevices;
