<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Nas extends Model
{
    use HasFactory;

    protected $fillable = [
        'nasname',
        'secret',
        'shortname',
        'description',
        'type',
        'mikrotick_user',
        'mikrotick_port',
        'mikrotick_user_password',
        'ip_block',
        'created_by'
    ];

    protected $table = 'nas';
    public $timestamps = false;

    public function editLog()
    {
        return $this->hasMany(LogHistory::class, 'log_id', 'id');
    }

}
